/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.mistral.embeddings;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class MistralEmbeddingsServiceSettings
extends FilteredXContentObject
implements ServiceSettings {
    public static final String NAME = "mistral_embeddings_service_settings";
    private final String model;
    private final Integer dimensions;
    private final SimilarityMeasure similarity;
    private final Integer maxInputTokens;
    private final RateLimitSettings rateLimitSettings;
    protected static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(240L);

    public static MistralEmbeddingsServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String model = ServiceUtils.extractRequiredString(map, "model", "service_settings", validationException);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer maxInputTokens = ServiceUtils.extractOptionalPositiveInteger(map, "max_input_tokens", "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "mistral", context);
        Integer dims = ServiceUtils.extractOptionalPositiveInteger(map, "dimensions", "service_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new MistralEmbeddingsServiceSettings(model, dims, maxInputTokens, similarity, rateLimitSettings);
    }

    public MistralEmbeddingsServiceSettings(StreamInput in) throws IOException {
        this.model = in.readString();
        this.dimensions = in.readOptionalVInt();
        this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
        this.maxInputTokens = in.readOptionalVInt();
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    public MistralEmbeddingsServiceSettings(String model, @Nullable Integer dimensions, @Nullable Integer maxInputTokens, @Nullable SimilarityMeasure similarity, @Nullable RateLimitSettings rateLimitSettings) {
        this.model = model;
        this.dimensions = dimensions;
        this.similarity = similarity;
        this.maxInputTokens = maxInputTokens;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }

    public String modelId() {
        return this.model;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return DenseVectorFieldMapper.ElementType.FLOAT;
    }

    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.model);
        out.writeOptionalVInt(this.dimensions);
        out.writeOptionalEnum((Enum)SimilarityMeasure.translateSimilarity((SimilarityMeasure)this.similarity, (TransportVersion)out.getTransportVersion()));
        out.writeOptionalVInt(this.maxInputTokens);
        this.rateLimitSettings.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("model", this.model);
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MistralEmbeddingsServiceSettings that = (MistralEmbeddingsServiceSettings)o;
        return Objects.equals(this.model, that.model) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.maxInputTokens, that.maxInputTokens) && Objects.equals(this.similarity, that.similarity);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.dimensions, this.maxInputTokens, this.similarity);
    }
}

