/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioEndpointType;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioProvider;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class AzureAiStudioServiceSettings
extends FilteredXContentObject
implements ServiceSettings {
    protected final String target;
    protected final AzureAiStudioProvider provider;
    protected final AzureAiStudioEndpointType endpointType;
    protected final RateLimitSettings rateLimitSettings;
    protected static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(240L);

    protected static BaseAzureAiStudioCommonFields fromMap(Map<String, Object> map, ValidationException validationException, ConfigurationParseContext context) {
        String target = ServiceUtils.extractRequiredString(map, "target", "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "azureaistudio", context);
        AzureAiStudioEndpointType endpointType = ServiceUtils.extractRequiredEnum(map, "endpoint_type", "service_settings", AzureAiStudioEndpointType::fromString, EnumSet.allOf(AzureAiStudioEndpointType.class), validationException);
        AzureAiStudioProvider provider = ServiceUtils.extractRequiredEnum(map, "provider", "service_settings", AzureAiStudioProvider::fromString, EnumSet.allOf(AzureAiStudioProvider.class), validationException);
        return new BaseAzureAiStudioCommonFields(target, provider, endpointType, rateLimitSettings);
    }

    protected AzureAiStudioServiceSettings(StreamInput in) throws IOException {
        this.target = in.readString();
        this.provider = (AzureAiStudioProvider)in.readEnum(AzureAiStudioProvider.class);
        this.endpointType = (AzureAiStudioEndpointType)in.readEnum(AzureAiStudioEndpointType.class);
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    protected AzureAiStudioServiceSettings(String target, AzureAiStudioProvider provider, AzureAiStudioEndpointType endpointType, @Nullable RateLimitSettings rateLimitSettings) {
        this.target = target;
        this.provider = provider;
        this.endpointType = endpointType;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public String target() {
        return this.target;
    }

    public AzureAiStudioProvider provider() {
        return this.provider;
    }

    public AzureAiStudioEndpointType endpointType() {
        return this.endpointType;
    }

    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public String modelId() {
        return null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.target);
        out.writeEnum((Enum)this.provider);
        out.writeEnum((Enum)this.endpointType);
        this.rateLimitSettings.writeTo(out);
    }

    protected void addXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.addExposedXContentFields(builder, params);
    }

    protected void addExposedXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("target", this.target);
        builder.field("provider", (Enum)this.provider);
        builder.field("endpoint_type", (Enum)this.endpointType);
        this.rateLimitSettings.toXContent(builder, params);
    }

    protected record BaseAzureAiStudioCommonFields(String target, AzureAiStudioProvider provider, AzureAiStudioEndpointType endpointType, RateLimitSettings rateLimitSettings) {
    }
}

