/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.cluster.metadata.InferenceFieldMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InferenceFieldMapper;
import org.elasticsearch.index.mapper.InferenceMetadataFieldsMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperMergeContext;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.SparseVectorFieldMapper;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.MinimalServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.vectors.KnnVectorQueryBuilder;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.inference.results.MlTextEmbeddingResults;
import org.elasticsearch.xpack.core.ml.inference.results.TextExpansionResults;
import org.elasticsearch.xpack.core.ml.search.SparseVectorQueryBuilder;
import org.elasticsearch.xpack.inference.mapper.OffsetSourceField;
import org.elasticsearch.xpack.inference.mapper.OffsetSourceFieldMapper;
import org.elasticsearch.xpack.inference.mapper.SemanticTextField;

public class SemanticTextFieldMapper
extends FieldMapper
implements InferenceFieldMapper {
    public static final NodeFeature SEMANTIC_TEXT_SEARCH_INFERENCE_ID = new NodeFeature("semantic_text.search_inference_id", true);
    public static final NodeFeature SEMANTIC_TEXT_DEFAULT_ELSER_2 = new NodeFeature("semantic_text.default_elser_2", true);
    public static final NodeFeature SEMANTIC_TEXT_IN_OBJECT_FIELD_FIX = new NodeFeature("semantic_text.in_object_field_fix");
    public static final NodeFeature SEMANTIC_TEXT_SINGLE_FIELD_UPDATE_FIX = new NodeFeature("semantic_text.single_field_update_fix");
    public static final NodeFeature SEMANTIC_TEXT_DELETE_FIX = new NodeFeature("semantic_text.delete_fix");
    public static final NodeFeature SEMANTIC_TEXT_ZERO_SIZE_FIX = new NodeFeature("semantic_text.zero_size_fix");
    public static final NodeFeature SEMANTIC_TEXT_ALWAYS_EMIT_INFERENCE_ID_FIX = new NodeFeature("semantic_text.always_emit_inference_id_fix");
    public static final NodeFeature SEMANTIC_TEXT_SKIP_INFERENCE_FIELDS = new NodeFeature("semantic_text.skip_inference_fields");
    public static final String CONTENT_TYPE = "semantic_text";
    public static final String DEFAULT_ELSER_2_INFERENCE_ID = ".elser-2-elasticsearch";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, arg_0 -> ((MappingParserContext)c).bitSetProducer(arg_0), c.getIndexSettings()), List.of(SemanticTextFieldMapper.validateParserContext("semantic_text")));

    public static BiConsumer<String, MappingParserContext> validateParserContext(String type) {
        return (n, c) -> {
            if (!InferenceMetadataFieldsMapper.isEnabled((Settings)c.getIndexSettings().getSettings())) {
                SemanticTextFieldMapper.notInMultiFields((String)type).accept(n, c);
            }
            SemanticTextFieldMapper.notFromDynamicTemplates((String)type).accept(n, c);
        };
    }

    private SemanticTextFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams) {
        super(simpleName, mappedFieldType, builderParams);
        this.ensureMultiFields(builderParams.multiFields().iterator());
    }

    private void ensureMultiFields(Iterator<FieldMapper> mappers) {
        while (mappers.hasNext()) {
            FieldMapper mapper = mappers.next();
            if (!mapper.leafName().equals("inference")) continue;
            throw new IllegalArgumentException("Field [" + mapper.fullPath() + "] is already used by another field [" + this.fullPath() + "] internally. Please choose a different name.");
        }
    }

    public Iterator<Mapper> iterator() {
        ArrayList<Object> mappers = new ArrayList<Object>();
        Iterator m = super.iterator();
        while (m.hasNext()) {
            mappers.add((Mapper)m.next());
        }
        mappers.add(this.fieldType().getInferenceField());
        return mappers.iterator();
    }

    public FieldMapper.Builder getMergeBuilder() {
        return Builder.from(this);
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        XContentLocation xContentLocation = parser.getTokenLocation();
        if (!this.fieldType().useLegacyFormat) {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                throw new DocumentParsingException(xContentLocation, "[semantic_text] field [" + this.fullPath() + "] does not support object values");
            }
            parser.skipChildren();
            return;
        }
        SemanticTextField field = this.parseSemanticTextField(context);
        if (field != null) {
            this.parseCreateFieldFromContext(context, field, xContentLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SemanticTextField parseSemanticTextField(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        boolean isWithinLeaf = context.path().isWithinLeafObject();
        try {
            context.path().setWithinLeafObject(true);
            SemanticTextField semanticTextField = SemanticTextField.parse(context.parser(), new SemanticTextField.ParserContext(this.fieldType().useLegacyFormat, this.fullPath(), context.parser().contentType()));
            return semanticTextField;
        }
        finally {
            context.path().setWithinLeafObject(isWithinLeaf);
        }
    }

    void parseCreateFieldFromContext(DocumentParserContext context, SemanticTextField field, XContentLocation xContentLocation) throws IOException {
        SemanticTextFieldMapper mapper;
        String fullFieldName = this.fieldType().name();
        if (!field.inference().inferenceId().equals(this.fieldType().getInferenceId())) {
            throw new DocumentParsingException(xContentLocation, Strings.format((String)"The configured %s [%s] for field [%s] doesn't match the %s [%s] reported in the document.", (Object[])new Object[]{"inference_id", field.inference().inferenceId(), fullFieldName, "inference_id", this.fieldType().getInferenceId()}));
        }
        if (this.fieldType().getModelSettings() == null) {
            mapper = this.addDynamicUpdate(context, field);
        } else {
            FieldMapper.Conflicts conflicts = new FieldMapper.Conflicts(fullFieldName);
            SemanticTextFieldMapper.canMergeModelSettings(this.fieldType().getModelSettings(), field.inference().modelSettings(), conflicts);
            try {
                conflicts.check();
            }
            catch (Exception exception) {
                throw new DocumentParsingException(xContentLocation, "Incompatible model settings for field [" + this.fullPath() + "]. Check that the inference_id is not using different model settings", exception);
            }
            mapper = this;
        }
        if (mapper.fieldType().getModelSettings() == null) {
            for (List list : field.inference().chunks().values()) {
                if (list.isEmpty()) continue;
                throw new DocumentParsingException(xContentLocation, "[model_settings] must be set for field [" + fullFieldName + "] when chunks are provided");
            }
        }
        NestedObjectMapper chunksField = mapper.fieldType().getChunksField();
        FieldMapper fieldMapper = mapper.fieldType().getEmbeddingsField();
        FieldMapper offsetsField = mapper.fieldType().getOffsetsField();
        for (Map.Entry<String, List<SemanticTextField.Chunk>> entry : field.inference().chunks().entrySet()) {
            for (SemanticTextField.Chunk chunk : entry.getValue()) {
                DocumentParserContext nestedContext = context.createNestedContext(chunksField);
                try (XContentParser subParser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)chunk.rawEmbeddings(), (XContentType)context.parser().contentType());){
                    DocumentParserContext subContext = nestedContext.switchParser(subParser);
                    subParser.nextToken();
                    fieldMapper.parse(subContext);
                }
                if (this.fieldType().useLegacyFormat) continue;
                XContentBuilder builder = XContentFactory.contentBuilder((XContentType)context.parser().contentType());
                try {
                    builder.startObject();
                    builder.field("field", entry.getKey());
                    builder.field("start", chunk.startOffset());
                    builder.field("end", chunk.endOffset());
                    builder.endObject();
                    XContentParser subParser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)BytesReference.bytes((XContentBuilder)builder), (XContentType)context.parser().contentType());
                    try {
                        DocumentParserContext subContext = nestedContext.switchParser(subParser);
                        subParser.nextToken();
                        offsetsField.parse(subContext);
                    }
                    finally {
                        if (subParser == null) continue;
                        subParser.close();
                    }
                }
                finally {
                    if (builder == null) continue;
                    builder.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SemanticTextFieldMapper addDynamicUpdate(DocumentParserContext context, SemanticTextField field) {
        Builder builder = (Builder)this.getMergeBuilder();
        context.path().remove();
        builder.setModelSettings(field.inference().modelSettings()).setInferenceId(field.inference().inferenceId());
        if (context.mappingLookup().isMultiField(this.fullPath())) {
            String fieldName = context.path().remove();
            try {
                FieldMapper.Builder parentMapper = ((FieldMapper)context.mappingLookup().getMapper(context.mappingLookup().parentField(this.fullPath()))).getMergeBuilder();
                context.addDynamicMapper((Mapper)parentMapper.addMultiField((FieldMapper.Builder)builder).build(context.createDynamicMapperBuilderContext()));
                SemanticTextFieldMapper semanticTextFieldMapper = builder.build(context.createDynamicMapperBuilderContext());
                return semanticTextFieldMapper;
            }
            finally {
                context.path().add(fieldName);
            }
        }
        SemanticTextFieldMapper mapper = builder.build(context.createDynamicMapperBuilderContext());
        context.addDynamicMapper((Mapper)mapper);
        SemanticTextFieldMapper semanticTextFieldMapper = mapper;
        return semanticTextFieldMapper;
        finally {
            context.path().add(this.leafName());
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public SemanticTextFieldType fieldType() {
        return (SemanticTextFieldType)super.fieldType();
    }

    public InferenceFieldMetadata getMetadata(Set<String> sourcePaths) {
        Object[] copyFields = (String[])sourcePaths.toArray(String[]::new);
        Arrays.sort(copyFields);
        return new InferenceFieldMetadata(this.fullPath(), this.fieldType().getInferenceId(), this.fieldType().getSearchInferenceId(), (String[])copyFields);
    }

    protected void doValidate(MappingLookup mappers) {
        String leafName;
        String fullPath = mappers.isMultiField(this.fullPath()) ? mappers.parentField(this.fullPath()) : this.fullPath();
        int parentPathIndex = fullPath.lastIndexOf(leafName = mappers.getMapper(fullPath).leafName());
        if (parentPathIndex > 0) {
            String parentName = fullPath.substring(0, parentPathIndex - 1);
            ObjectMapper parentMapper = (ObjectMapper)mappers.objectMappers().get(parentName);
            if (parentMapper == null) {
                throw new IllegalStateException("semantic_text field [" + this.fullPath() + "] does not have a parent object mapper");
            }
            if (parentMapper.subobjects() == ObjectMapper.Subobjects.DISABLED) {
                throw new IllegalArgumentException("semantic_text field [" + this.fullPath() + "] cannot be in an object field with subobjects disabled");
            }
        }
    }

    private static ObjectMapper createInferenceField(MapperBuilderContext context, IndexVersion indexVersionCreated, boolean useLegacyFormat, @Nullable MinimalServiceSettings modelSettings, Function<Query, BitSetProducer> bitSetProducer, IndexSettings indexSettings) {
        return new ObjectMapper.Builder("inference", Optional.of(ObjectMapper.Subobjects.ENABLED)).dynamic(ObjectMapper.Dynamic.FALSE).add((Mapper.Builder)SemanticTextFieldMapper.createChunksField(indexVersionCreated, useLegacyFormat, modelSettings, bitSetProducer, indexSettings)).build(context);
    }

    private static NestedObjectMapper.Builder createChunksField(IndexVersion indexVersionCreated, boolean useLegacyFormat, @Nullable MinimalServiceSettings modelSettings, Function<Query, BitSetProducer> bitSetProducer, IndexSettings indexSettings) {
        NestedObjectMapper.Builder chunksField = new NestedObjectMapper.Builder("chunks", indexSettings.getIndexVersionCreated(), bitSetProducer, indexSettings);
        chunksField.dynamic(ObjectMapper.Dynamic.FALSE);
        if (modelSettings != null) {
            chunksField.add(SemanticTextFieldMapper.createEmbeddingsField(indexSettings.getIndexVersionCreated(), modelSettings, useLegacyFormat));
        }
        if (useLegacyFormat) {
            KeywordFieldMapper.Builder chunkTextField = new KeywordFieldMapper.Builder("text", indexVersionCreated).indexed(false).docValues(false);
            chunksField.add((Mapper.Builder)chunkTextField);
        } else {
            chunksField.add((Mapper.Builder)new OffsetSourceFieldMapper.Builder("offset"));
        }
        return chunksField;
    }

    private static Mapper.Builder createEmbeddingsField(IndexVersion indexVersionCreated, MinimalServiceSettings modelSettings, boolean useLegacyFormat) {
        return switch (modelSettings.taskType()) {
            case TaskType.SPARSE_EMBEDDING -> new SparseVectorFieldMapper.Builder("embeddings").setStored(!useLegacyFormat);
            case TaskType.TEXT_EMBEDDING -> {
                DenseVectorFieldMapper.Builder denseVectorMapperBuilder = new DenseVectorFieldMapper.Builder("embeddings", indexVersionCreated);
                SimilarityMeasure similarity = modelSettings.similarity();
                if (similarity != null) {
                    switch (similarity) {
                        case COSINE: {
                            denseVectorMapperBuilder.similarity(DenseVectorFieldMapper.VectorSimilarity.COSINE);
                            break;
                        }
                        case DOT_PRODUCT: {
                            denseVectorMapperBuilder.similarity(DenseVectorFieldMapper.VectorSimilarity.DOT_PRODUCT);
                            break;
                        }
                        case L2_NORM: {
                            denseVectorMapperBuilder.similarity(DenseVectorFieldMapper.VectorSimilarity.L2_NORM);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown similarity measure in model_settings [" + similarity.name() + "]");
                        }
                    }
                }
                denseVectorMapperBuilder.dimensions(modelSettings.dimensions().intValue());
                denseVectorMapperBuilder.elementType(modelSettings.elementType());
                yield denseVectorMapperBuilder;
            }
            default -> throw new IllegalArgumentException("Invalid task_type in model_settings [" + modelSettings.taskType().name() + "]");
        };
    }

    private static boolean canMergeModelSettings(MinimalServiceSettings previous, MinimalServiceSettings current, FieldMapper.Conflicts conflicts) {
        if (Objects.equals(previous, current)) {
            return true;
        }
        if (previous == null || current == null) {
            return true;
        }
        conflicts.addConflict("model_settings", "");
        return false;
    }

    public static class SemanticTextFieldType
    extends SimpleMappedFieldType {
        private final String inferenceId;
        private final String searchInferenceId;
        private final MinimalServiceSettings modelSettings;
        private final ObjectMapper inferenceField;
        private final boolean useLegacyFormat;

        public SemanticTextFieldType(String name, String inferenceId, String searchInferenceId, MinimalServiceSettings modelSettings, ObjectMapper inferenceField, boolean useLegacyFormat, Map<String, String> meta) {
            super(name, true, false, false, TextSearchInfo.NONE, meta);
            this.inferenceId = inferenceId;
            this.searchInferenceId = searchInferenceId;
            this.modelSettings = modelSettings;
            this.inferenceField = inferenceField;
            this.useLegacyFormat = useLegacyFormat;
        }

        public boolean useLegacyFormat() {
            return this.useLegacyFormat;
        }

        public String typeName() {
            return SemanticTextFieldMapper.CONTENT_TYPE;
        }

        public String familyTypeName() {
            return "text";
        }

        public String getDefaultHighlighter() {
            return "semantic";
        }

        public String getInferenceId() {
            return this.inferenceId;
        }

        public String getSearchInferenceId() {
            return this.searchInferenceId == null ? this.inferenceId : this.searchInferenceId;
        }

        public MinimalServiceSettings getModelSettings() {
            return this.modelSettings;
        }

        public ObjectMapper getInferenceField() {
            return this.inferenceField;
        }

        public NestedObjectMapper getChunksField() {
            return (NestedObjectMapper)this.inferenceField.getMapper("chunks");
        }

        public FieldMapper getEmbeddingsField() {
            return (FieldMapper)this.getChunksField().getMapper("embeddings");
        }

        public FieldMapper getOffsetsField() {
            return (FieldMapper)this.getChunksField().getMapper("offset");
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("semantic_text fields do not support term query");
        }

        public Query existsQuery(SearchExecutionContext context) {
            if (this.getEmbeddingsField() == null) {
                return new MatchNoDocsQuery();
            }
            return NestedQueryBuilder.toQuery(c -> this.getEmbeddingsField().fieldType().existsQuery(c), (String)SemanticTextField.getChunksFieldName(this.name()), (ScoreMode)ScoreMode.None, (boolean)false, (SearchExecutionContext)context);
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (this.useLegacyFormat) {
                return SourceValueFetcher.toString((String)SemanticTextField.getOriginalTextFieldName(this.name()), (SearchExecutionContext)context, (String)format);
            }
            return SourceValueFetcher.toString((String)this.name(), (SearchExecutionContext)context, null);
        }

        ValueFetcher valueFetcherWithInferenceResults(Function<Query, BitSetProducer> bitSetCache, IndexSearcher searcher) {
            FieldMapper embeddingsField = this.getEmbeddingsField();
            if (embeddingsField == null) {
                return ValueFetcher.EMPTY;
            }
            try {
                SourceLoader.SyntheticFieldLoader embeddingsLoader = embeddingsField.syntheticFieldLoader();
                BitSetProducer bitSetFilter = bitSetCache.apply(this.getChunksField().parentTypeFilter());
                Weight childWeight = searcher.createWeight(this.getChunksField().nestedTypeFilter(), org.apache.lucene.search.ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                return new SemanticTextFieldValueFetcher(bitSetFilter, childWeight, embeddingsLoader);
            }
            catch (IOException exc) {
                throw new UncheckedIOException(exc);
            }
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            throw new IllegalArgumentException("[semantic_text] fields do not support sorting, scripting or aggregating");
        }

        public boolean fieldHasValue(FieldInfos fieldInfos) {
            return fieldInfos.fieldInfo(SemanticTextField.getEmbeddingsFieldName(this.name())) != null;
        }

        public QueryBuilder semanticQuery(InferenceResults inferenceResults, Integer requestSize, float boost, String queryName) {
            MatchNoneQueryBuilder childQueryBuilder;
            String nestedFieldPath = SemanticTextField.getChunksFieldName(this.name());
            String inferenceResultsFieldName = SemanticTextField.getEmbeddingsFieldName(this.name());
            if (this.modelSettings == null) {
                childQueryBuilder = new MatchNoneQueryBuilder();
            } else {
                childQueryBuilder = switch (this.modelSettings.taskType()) {
                    case TaskType.SPARSE_EMBEDDING -> {
                        if (!(inferenceResults instanceof TextExpansionResults)) {
                            throw new IllegalArgumentException(this.generateQueryInferenceResultsTypeMismatchMessage(inferenceResults, "text_expansion_result"));
                        }
                        TextExpansionResults textExpansionResults = (TextExpansionResults)inferenceResults;
                        yield new SparseVectorQueryBuilder(inferenceResultsFieldName, textExpansionResults.getWeightedTokens(), null, null, null, null);
                    }
                    case TaskType.TEXT_EMBEDDING -> {
                        if (!(inferenceResults instanceof MlTextEmbeddingResults)) {
                            throw new IllegalArgumentException(this.generateQueryInferenceResultsTypeMismatchMessage(inferenceResults, "text_embedding_result"));
                        }
                        MlTextEmbeddingResults textEmbeddingResults = (MlTextEmbeddingResults)inferenceResults;
                        float[] inference = textEmbeddingResults.getInferenceAsFloat();
                        if (inference.length != this.modelSettings.dimensions()) {
                            throw new IllegalArgumentException(this.generateDimensionCountMismatchMessage(inference.length, this.modelSettings.dimensions()));
                        }
                        Integer k = requestSize;
                        if (k != null) {
                            k = Math.max(k, 10);
                        }
                        yield new KnnVectorQueryBuilder(inferenceResultsFieldName, inference, k, null, null, null);
                    }
                    default -> throw new IllegalStateException("Field [" + this.name() + "] is configured to use an inference endpoint with an unsupported task type [" + String.valueOf(this.modelSettings.taskType()) + "]");
                };
            }
            return ((NestedQueryBuilder)new NestedQueryBuilder(nestedFieldPath, (QueryBuilder)childQueryBuilder, ScoreMode.Max).boost(boost)).queryName(queryName);
        }

        private String generateQueryInferenceResultsTypeMismatchMessage(InferenceResults inferenceResults, String expectedResultsType) {
            StringBuilder sb = new StringBuilder("Field [" + this.name() + "] expected query inference results to be of type [" + expectedResultsType + "], got [" + inferenceResults.getWriteableName() + "].");
            return this.generateInvalidQueryInferenceResultsMessage(sb);
        }

        private String generateDimensionCountMismatchMessage(int inferenceDimCount, int expectedDimCount) {
            StringBuilder sb = new StringBuilder("Field [" + this.name() + "] expected query inference results with " + expectedDimCount + " dimensions, got " + inferenceDimCount + " dimensions.");
            return this.generateInvalidQueryInferenceResultsMessage(sb);
        }

        private String generateInvalidQueryInferenceResultsMessage(StringBuilder baseMessageBuilder) {
            if (this.searchInferenceId != null && !this.searchInferenceId.equals(this.inferenceId)) {
                baseMessageBuilder.append(" Is the search inference endpoint [" + this.searchInferenceId + "] compatible with the inference endpoint [" + this.inferenceId + "]?");
            } else {
                baseMessageBuilder.append(" Has the configuration for inference endpoint [" + this.inferenceId + "] changed?");
            }
            return baseMessageBuilder.toString();
        }

        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            String name = this.useLegacyFormat ? this.name().concat(".text") : this.name();
            SourceValueFetcher fetcher = SourceValueFetcher.toString((Set)blContext.sourcePaths(name));
            return new BlockSourceReader.BytesRefsBlockLoader((ValueFetcher)fetcher, BlockSourceReader.lookupMatchingAll());
        }

        private class SemanticTextFieldValueFetcher
        implements ValueFetcher {
            private final BitSetProducer parentBitSetProducer;
            private final Weight childWeight;
            private final SourceLoader.SyntheticFieldLoader fieldLoader;
            private BitSet bitSet;
            private Scorer childScorer;
            private SourceLoader.SyntheticFieldLoader.DocValuesLoader dvLoader;
            private OffsetSourceField.OffsetSourceLoader offsetsLoader;

            private SemanticTextFieldValueFetcher(BitSetProducer bitSetProducer, Weight childWeight, SourceLoader.SyntheticFieldLoader fieldLoader) {
                this.parentBitSetProducer = bitSetProducer;
                this.childWeight = childWeight;
                this.fieldLoader = fieldLoader;
            }

            public void setNextReader(LeafReaderContext context) {
                try {
                    this.bitSet = this.parentBitSetProducer.getBitSet(context);
                    this.childScorer = this.childWeight.scorer(context);
                    if (this.childScorer != null) {
                        this.childScorer.iterator().nextDoc();
                    }
                    this.dvLoader = this.fieldLoader.docValuesLoader(context.reader(), null);
                    Terms terms = context.reader().terms(SemanticTextField.getOffsetsFieldName(SemanticTextFieldType.this.name()));
                    this.offsetsLoader = terms != null ? OffsetSourceField.loader(terms) : null;
                }
                catch (IOException exc) {
                    throw new UncheckedIOException(exc);
                }
            }

            public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) throws IOException {
                if (this.childScorer == null || this.offsetsLoader == null || doc == 0) {
                    return List.of();
                }
                int previousParent = this.bitSet.prevSetBit(doc - 1);
                DocIdSetIterator it = this.childScorer.iterator();
                if (it.docID() < previousParent) {
                    it.advance(previousParent);
                }
                LinkedHashMap<String, List<SemanticTextField.Chunk>> chunkMap = new LinkedHashMap<String, List<SemanticTextField.Chunk>>();
                while (it.docID() < doc) {
                    if (this.dvLoader == null || !this.dvLoader.advanceToDoc(it.docID())) {
                        throw new IllegalStateException("Cannot fetch values for field [" + SemanticTextFieldType.this.name() + "], missing embeddings for doc [" + doc + "]");
                    }
                    OffsetSourceFieldMapper.OffsetSource offset = this.offsetsLoader.advanceTo(it.docID());
                    if (offset == null) {
                        throw new IllegalStateException("Cannot fetch values for field [" + SemanticTextFieldType.this.name() + "], missing offsets for doc [" + doc + "]");
                    }
                    List chunks = chunkMap.computeIfAbsent(offset.field(), k -> new ArrayList());
                    chunks.add(new SemanticTextField.Chunk(null, offset.start(), offset.end(), this.rawEmbeddings((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)arg_0 -> ((SourceLoader.SyntheticFieldLoader)this.fieldLoader).write(arg_0)), source.sourceContentType())));
                    if (it.nextDoc() != Integer.MAX_VALUE) continue;
                    break;
                }
                if (chunkMap.isEmpty()) {
                    return List.of();
                }
                return List.of(new SemanticTextField(SemanticTextFieldType.this.useLegacyFormat, SemanticTextFieldType.this.name(), null, new SemanticTextField.InferenceResult(SemanticTextFieldType.this.inferenceId, SemanticTextFieldType.this.modelSettings, chunkMap), source.sourceContentType()));
            }

            private BytesReference rawEmbeddings(CheckedConsumer<XContentBuilder, IOException> writer, XContentType xContentType) throws IOException {
                try (XContentBuilder result = XContentFactory.contentBuilder((XContentType)xContentType);){
                    BytesReference bytesReference;
                    block19: {
                        XContentBuilder builder = XContentFactory.contentBuilder((XContentType)xContentType);
                        try {
                            builder.startObject();
                            writer.accept((Object)builder);
                            builder.endObject();
                            try (XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)BytesReference.bytes((XContentBuilder)builder), (XContentType)xContentType);){
                                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                parser.nextToken();
                                result.copyCurrentStructure(parser);
                            }
                            bytesReference = BytesReference.bytes((XContentBuilder)result);
                            if (builder == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (builder != null) {
                                try {
                                    builder.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        builder.close();
                    }
                    return bytesReference;
                }
            }

            public StoredFieldsSpec storedFieldsSpec() {
                return StoredFieldsSpec.NO_REQUIREMENTS;
            }
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final boolean useLegacyFormat;
        private final FieldMapper.Parameter<String> inferenceId = FieldMapper.Parameter.stringParam((String)"inference_id", (boolean)false, mapper -> ((SemanticTextFieldType)mapper.fieldType()).inferenceId, (String)".elser-2-elasticsearch").addValidator(v -> {
            if (Strings.isEmpty((CharSequence)v)) {
                throw new IllegalArgumentException("[inference_id] on mapper [" + this.leafName() + "] of type [semantic_text] must not be empty");
            }
        }).alwaysSerialize();
        private final FieldMapper.Parameter<String> searchInferenceId = FieldMapper.Parameter.stringParam((String)"search_inference_id", (boolean)true, mapper -> ((SemanticTextFieldType)mapper.fieldType()).searchInferenceId, null).acceptsNull().addValidator(v -> {
            if (v != null && Strings.isEmpty((CharSequence)v)) {
                throw new IllegalArgumentException("[search_inference_id] on mapper [" + this.leafName() + "] of type [semantic_text] must not be empty");
            }
        });
        private final FieldMapper.Parameter<MinimalServiceSettings> modelSettings = new FieldMapper.Parameter("model_settings", true, () -> null, (n, c, o) -> SemanticTextField.parseModelSettingsFromMap(o), mapper -> ((SemanticTextFieldType)mapper.fieldType()).modelSettings, XContentBuilder::field, Objects::toString).acceptsNull().setMergeValidator(SemanticTextFieldMapper::canMergeModelSettings);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private Function<MapperBuilderContext, ObjectMapper> inferenceFieldBuilder;

        public static Builder from(SemanticTextFieldMapper mapper) {
            Builder builder = new Builder(mapper.leafName(), mapper.fieldType().getChunksField().bitsetProducer(), mapper.fieldType().getChunksField().indexSettings());
            builder.init(mapper);
            return builder;
        }

        public Builder(String name, Function<Query, BitSetProducer> bitSetProducer, IndexSettings indexSettings) {
            super(name);
            this.useLegacyFormat = !InferenceMetadataFieldsMapper.isEnabled((Settings)indexSettings.getSettings());
            this.inferenceFieldBuilder = c -> SemanticTextFieldMapper.createInferenceField(c, indexSettings.getIndexVersionCreated(), this.useLegacyFormat, (MinimalServiceSettings)this.modelSettings.get(), bitSetProducer, indexSettings);
        }

        public Builder setInferenceId(String id) {
            this.inferenceId.setValue((Object)id);
            return this;
        }

        public Builder setSearchInferenceId(String id) {
            this.searchInferenceId.setValue((Object)id);
            return this;
        }

        public Builder setModelSettings(MinimalServiceSettings value) {
            this.modelSettings.setValue((Object)value);
            return this;
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.inferenceId, this.searchInferenceId, this.modelSettings, this.meta};
        }

        protected void merge(FieldMapper mergeWith, FieldMapper.Conflicts conflicts, MapperMergeContext mapperMergeContext) {
            SemanticTextFieldMapper semanticMergeWith = (SemanticTextFieldMapper)mergeWith;
            semanticMergeWith = this.copySettings(semanticMergeWith, mapperMergeContext);
            super.merge((FieldMapper)semanticMergeWith, conflicts, mapperMergeContext);
            conflicts.check();
            MapperMergeContext context = mapperMergeContext.createChildContext(semanticMergeWith.leafName(), ObjectMapper.Dynamic.FALSE);
            ObjectMapper inferenceField = this.inferenceFieldBuilder.apply(context.getMapperBuilderContext());
            ObjectMapper mergedInferenceField = inferenceField.merge((Mapper)semanticMergeWith.fieldType().getInferenceField(), context);
            this.inferenceFieldBuilder = c -> mergedInferenceField;
        }

        public SemanticTextFieldMapper build(MapperBuilderContext context) {
            if (this.useLegacyFormat && !this.copyTo.copyToFields().isEmpty()) {
                throw new IllegalArgumentException("semantic_text field [" + this.leafName() + "] does not support [copy_to]");
            }
            if (this.useLegacyFormat && this.multiFieldsBuilder.hasMultiFields()) {
                throw new IllegalArgumentException("semantic_text field [" + this.leafName() + "] does not support multi-fields");
            }
            if (this.modelSettings.get() != null) {
                this.validateServiceSettings((MinimalServiceSettings)this.modelSettings.get());
            }
            String fullName = context.buildFullName(this.leafName());
            if (context.isInNestedContext()) {
                throw new IllegalArgumentException("semantic_text field [" + fullName + "] cannot be nested");
            }
            MapperBuilderContext childContext = context.createChildContext(this.leafName(), ObjectMapper.Dynamic.FALSE);
            ObjectMapper inferenceField = this.inferenceFieldBuilder.apply(childContext);
            return new SemanticTextFieldMapper(this.leafName(), (MappedFieldType)new SemanticTextFieldType(fullName, (String)this.inferenceId.getValue(), (String)this.searchInferenceId.getValue(), (MinimalServiceSettings)this.modelSettings.getValue(), inferenceField, this.useLegacyFormat, (Map)this.meta.getValue()), this.builderParams((Mapper.Builder)this, context));
        }

        private void validateServiceSettings(MinimalServiceSettings settings) {
            switch (settings.taskType()) {
                case SPARSE_EMBEDDING: 
                case TEXT_EMBEDDING: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong [task_type], expected " + String.valueOf(TaskType.TEXT_EMBEDDING) + " or " + String.valueOf(TaskType.SPARSE_EMBEDDING) + ", got " + settings.taskType().name());
                }
            }
        }

        private SemanticTextFieldMapper copySettings(SemanticTextFieldMapper mapper, MapperMergeContext mapperMergeContext) {
            SemanticTextFieldMapper returnedMapper = mapper;
            if (mapper.fieldType().getModelSettings() == null) {
                Builder builder = Builder.from(mapper);
                builder.setModelSettings((MinimalServiceSettings)this.modelSettings.getValue());
                returnedMapper = builder.build(mapperMergeContext.getMapperBuilderContext());
            }
            return returnedMapper;
        }
    }
}

