/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.ibmwatsonx;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Strings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.common.socket.SocketAccess;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public interface IbmWatsonxRequest
extends Request {
    public static void decorateWithBearerToken(HttpPost httpPost, DefaultSecretSettings secretSettings, String inferenceId) {
        Logger logger = LogManager.getLogger(IbmWatsonxRequest.class);
        String bearerTokenGenUrl = "https://iam.cloud.ibm.com/identity/token";
        String bearerToken = "";
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPostForBearerToken = new HttpPost(bearerTokenGenUrl);
            String body = "grant_type=urn:ibm:params:oauth:grant-type:apikey&apikey=" + secretSettings.apiKey().toString();
            ByteArrayEntity byteEntity = new ByteArrayEntity(body.getBytes(StandardCharsets.UTF_8));
            httpPostForBearerToken.setEntity((HttpEntity)byteEntity);
            httpPostForBearerToken.setHeader("Content-Type", "application/x-www-form-urlencoded");
            bearerToken = (String)SocketAccess.doPrivileged(() -> {
                Map map;
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPostForBearerToken);
                IbmWatsonxRequest.validateResponse(bearerTokenGenUrl, inferenceId, (HttpResponse)response);
                HttpEntity entity = response.getEntity();
                try (InputStream content = entity.getContent();){
                    XContentType xContentType = XContentType.fromMediaType((String)entity.getContentType().getValue());
                    map = XContentHelper.convertToMap((XContent)xContentType.xContent(), (InputStream)content, (boolean)false);
                }
                return (String)map.get("access_token");
            });
        }
        catch (IOException e) {
            throw new XContentParseException("Failed to add Bearer token to the request");
        }
        BasicHeader bearerHeader = new BasicHeader("Authorization", "Bearer " + bearerToken);
        httpPost.setHeader((Header)bearerHeader);
    }

    public static void validateResponse(String bearerTokenGenUrl, String inferenceId, HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return;
        }
        if (statusCode == 500) {
            throw new RetryException(true, IbmWatsonxRequest.buildError("Received a server error status code", inferenceId, response));
        }
        if (statusCode == 404) {
            throw new RetryException(false, IbmWatsonxRequest.buildError(IbmWatsonxRequest.resourceNotFoundError(bearerTokenGenUrl), inferenceId, response));
        }
        if (statusCode == 403) {
            throw new RetryException(false, IbmWatsonxRequest.buildError("Received a permission denied error status code", inferenceId, response));
        }
        if (statusCode == 401) {
            throw new RetryException(false, IbmWatsonxRequest.buildError("Received an authentication error status code", inferenceId, response));
        }
        if (statusCode == 400) {
            throw new RetryException(false, IbmWatsonxRequest.buildError("Received a bad request status code", inferenceId, response));
        }
        if (statusCode >= 300 && statusCode < 400) {
            throw new RetryException(false, IbmWatsonxRequest.buildError("Unhandled redirection", inferenceId, response));
        }
        throw new RetryException(false, IbmWatsonxRequest.buildError("Received an unsuccessful status code", inferenceId, response));
    }

    private static String resourceNotFoundError(String bearerTokenGenUrl) {
        return Strings.format((String)"Resource not found at [%s]", (Object[])new Object[]{bearerTokenGenUrl});
    }

    private static Exception buildError(String message, String inferenceId, HttpResponse response) {
        String errorMsg = response.getStatusLine().getReasonPhrase();
        int responseStatusCode = response.getStatusLine().getStatusCode();
        if (errorMsg == null) {
            return new ElasticsearchStatusException(Strings.format((String)"%s for request to generate Bearer Token from inference entity id [%s] status [%s]", (Object[])new Object[]{message, inferenceId, responseStatusCode}), IbmWatsonxRequest.toRestStatus(responseStatusCode), new Object[0]);
        }
        return new ElasticsearchStatusException(Strings.format((String)"%s for request to generate Bearer Token from inference entity id [%s] status [%s]. Error message: [%s]", (Object[])new Object[]{message, inferenceId, responseStatusCode, errorMsg}), IbmWatsonxRequest.toRestStatus(responseStatusCode), new Object[0]);
    }

    private static RestStatus toRestStatus(int statusCode) {
        RestStatus code = null;
        if (statusCode < 500) {
            code = RestStatus.fromCode((int)statusCode);
        }
        return code == null ? RestStatus.BAD_REQUEST : code;
    }
}

