/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.googleaistudio;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record GoogleAiStudioEmbeddingsRequestEntity(List<String> inputs, String model, @Nullable Integer dimensions) implements ToXContentObject
{
    private static final String REQUESTS_FIELD = "requests";
    private static final String MODEL_FIELD = "model";
    private static final String MODELS_PREFIX = "models";
    private static final String CONTENT_FIELD = "content";
    private static final String PARTS_FIELD = "parts";
    private static final String TEXT_FIELD = "text";
    private static final String OUTPUT_DIMENSIONALITY_FIELD = "outputDimensionality";

    public GoogleAiStudioEmbeddingsRequestEntity {
        Objects.requireNonNull(inputs);
        Objects.requireNonNull(model);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(REQUESTS_FIELD);
        for (String input : this.inputs) {
            builder.startObject();
            builder.field(MODEL_FIELD, Strings.format((String)"%s/%s", (Object[])new Object[]{MODELS_PREFIX, this.model}));
            builder.startObject(CONTENT_FIELD);
            builder.startArray(PARTS_FIELD);
            builder.startObject();
            builder.field(TEXT_FIELD, input);
            builder.endObject();
            builder.endArray();
            builder.endObject();
            if (this.dimensions != null) {
                builder.field(OUTPUT_DIMENSIONALITY_FIELD, this.dimensions);
            }
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }
}

