/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.openai;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.openai.OpenAiModel;

public record OpenAiAccount(URI uri, @Nullable String organizationId, SecureString apiKey) {
    public OpenAiAccount {
        Objects.requireNonNull(uri);
        Objects.requireNonNull(apiKey);
    }

    public static OpenAiAccount of(OpenAiModel model, CheckedSupplier<URI, URISyntaxException> uriBuilder) {
        URI uri = RequestUtils.buildUri(model.rateLimitServiceSettings().uri(), "OpenAI", uriBuilder);
        return new OpenAiAccount(uri, model.rateLimitServiceSettings().organizationId(), model.apiKey());
    }
}

