/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.retry;

import java.util.List;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;

public class RetrySettings {
    static final Setting<TimeValue> RETRY_INITIAL_DELAY_SETTING = Setting.timeSetting((String)"xpack.inference.http.retry.initial_delay", (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<TimeValue> RETRY_MAX_DELAY_BOUND_SETTING = Setting.timeSetting((String)"xpack.inference.http.retry.max_delay_bound", (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<TimeValue> RETRY_TIMEOUT_SETTING = Setting.timeSetting((String)"xpack.inference.http.retry.timeout", (TimeValue)TimeValue.timeValueSeconds((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<DebugFrequencyMode> RETRY_DEBUG_FREQUENCY_MODE_SETTING = Setting.enumSetting(DebugFrequencyMode.class, (String)"xpack.inference.http.retry.debug_frequency_mode", (Enum)DebugFrequencyMode.OFF, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<TimeValue> RETRY_DEBUG_FREQUENCY_AMOUNT_SETTING = Setting.timeSetting((String)"xpack.inference.http.retry.debug_frequency_amount", (TimeValue)TimeValue.timeValueMinutes((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private volatile TimeValue initialDelay;
    private volatile TimeValue maxDelayBound;
    private volatile TimeValue timeout;
    private volatile DebugFrequencyMode debugMode;
    private volatile TimeValue debugFrequency;

    public RetrySettings(Settings settings, ClusterService clusterService) {
        this.initialDelay = (TimeValue)RETRY_INITIAL_DELAY_SETTING.get(settings);
        this.maxDelayBound = (TimeValue)RETRY_MAX_DELAY_BOUND_SETTING.get(settings);
        this.timeout = (TimeValue)RETRY_TIMEOUT_SETTING.get(settings);
        this.debugMode = (DebugFrequencyMode)((Object)RETRY_DEBUG_FREQUENCY_MODE_SETTING.get(settings));
        this.debugFrequency = (TimeValue)RETRY_DEBUG_FREQUENCY_AMOUNT_SETTING.get(settings);
        this.addSettingsUpdateConsumers(clusterService);
    }

    private void addSettingsUpdateConsumers(ClusterService clusterService) {
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RETRY_INITIAL_DELAY_SETTING, this::setInitialDelay);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RETRY_MAX_DELAY_BOUND_SETTING, this::setMaxDelayBound);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RETRY_TIMEOUT_SETTING, this::setTimeout);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RETRY_DEBUG_FREQUENCY_MODE_SETTING, this::setDebugMode);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RETRY_DEBUG_FREQUENCY_AMOUNT_SETTING, this::setDebugFrequencyAmount);
    }

    private void setInitialDelay(TimeValue initialDelay) {
        this.initialDelay = initialDelay;
    }

    private void setMaxDelayBound(TimeValue maxDelayBound) {
        this.maxDelayBound = maxDelayBound;
    }

    private void setTimeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    private void setDebugMode(DebugFrequencyMode debugMode) {
        this.debugMode = debugMode;
    }

    private void setDebugFrequencyAmount(TimeValue debugFrequency) {
        this.debugFrequency = debugFrequency;
    }

    public static List<Setting<?>> getSettingsDefinitions() {
        return List.of(RETRY_INITIAL_DELAY_SETTING, RETRY_MAX_DELAY_BOUND_SETTING, RETRY_TIMEOUT_SETTING, RETRY_DEBUG_FREQUENCY_MODE_SETTING, RETRY_DEBUG_FREQUENCY_AMOUNT_SETTING);
    }

    TimeValue getInitialDelay() {
        return this.initialDelay;
    }

    TimeValue getMaxDelayBound() {
        return this.maxDelayBound;
    }

    TimeValue getTimeout() {
        return this.timeout;
    }

    DebugFrequencyMode getDebugMode() {
        return this.debugMode;
    }

    TimeValue getDebugFrequency() {
        return this.debugFrequency;
    }

    static enum DebugFrequencyMode {
        ON,
        OFF,
        INTERVAL;

    }
}

