/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.amazonbedrock;

import java.io.IOException;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockExecuteOnlyRequestSender;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockInferenceClient;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockInferenceClientCache;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.AmazonBedrockRequestExecutorService;
import org.elasticsearch.xpack.inference.external.http.sender.AmazonBedrockRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.RequestExecutorServiceSettings;
import org.elasticsearch.xpack.inference.external.http.sender.RequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.ServiceComponents;

public class AmazonBedrockRequestSender
implements Sender {
    private static final TimeValue START_COMPLETED_WAIT_TIME = TimeValue.timeValueSeconds((long)5L);
    private final ThreadPool threadPool;
    private final AmazonBedrockRequestExecutorService executorService;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final CountDownLatch startCompleted = new CountDownLatch(1);

    protected AmazonBedrockRequestSender(ThreadPool threadPool, ClusterService clusterService, Settings settings, AmazonBedrockExecuteOnlyRequestSender requestSender) {
        this.threadPool = Objects.requireNonNull(threadPool);
        this.executorService = new AmazonBedrockRequestExecutorService(threadPool, this.startCompleted, new RequestExecutorServiceSettings(settings, clusterService), requestSender);
    }

    @Override
    public void updateRateLimitDivisor(int rateLimitDivisor) {
        this.executorService.updateRateLimitDivisor(rateLimitDivisor);
    }

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.threadPool.executor("inference_utility").execute(() -> this.executorService.start());
            this.waitForStartToComplete();
        }
    }

    private void waitForStartToComplete() {
        try {
            if (!this.startCompleted.await(START_COMPLETED_WAIT_TIME.getSeconds(), TimeUnit.SECONDS)) {
                throw new IllegalStateException("Amazon Bedrock sender startup did not complete in time");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Amazon Bedrock sender interrupted while waiting for startup to complete");
        }
    }

    @Override
    public void send(RequestManager requestCreator, InferenceInputs inferenceInputs, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        assert (this.started.get()) : "Amazon Bedrock request sender: call start() before sending a request";
        this.waitForStartToComplete();
        if (requestCreator instanceof AmazonBedrockRequestManager) {
            AmazonBedrockRequestManager amazonBedrockRequestManager = (AmazonBedrockRequestManager)requestCreator;
            this.executorService.execute((RequestManager)amazonBedrockRequestManager, inferenceInputs, timeout, (ActionListener)listener);
            return;
        }
        listener.onFailure((Exception)new ElasticsearchException("Amazon Bedrock request sender did not receive a valid request request manager", new Object[0]));
    }

    @Override
    public void sendWithoutQueuing(Logger logger, Request request, ResponseHandler responseHandler, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void close() throws IOException {
        this.executorService.shutdown();
    }

    public static class Factory {
        private final ServiceComponents serviceComponents;
        private final ClusterService clusterService;

        public Factory(ServiceComponents serviceComponents, ClusterService clusterService) {
            this.serviceComponents = Objects.requireNonNull(serviceComponents);
            this.clusterService = Objects.requireNonNull(clusterService);
        }

        public Sender createSender() {
            AmazonBedrockInferenceClientCache clientCache = new AmazonBedrockInferenceClientCache((model, timeout) -> AmazonBedrockInferenceClient.create(model, timeout, this.serviceComponents.threadPool()), Clock.systemUTC());
            return this.createSender(new AmazonBedrockExecuteOnlyRequestSender(clientCache, this.serviceComponents.throttlerManager()));
        }

        Sender createSender(AmazonBedrockExecuteOnlyRequestSender requestSender) {
            AmazonBedrockRequestSender sender = new AmazonBedrockRequestSender(this.serviceComponents.threadPool(), this.clusterService, this.serviceComponents.settings(), Objects.requireNonNull(requestSender));
            sender.start();
            return sender;
        }
    }
}

