/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.PublishableHttpResource;

public class TemplateHttpResource
extends PublishableHttpResource {
    private static final Logger logger = LogManager.getLogger(TemplateHttpResource.class);
    public static final Map<String, String> PARAMETERS;
    private final String templateName;

    public TemplateHttpResource(String resourceOwnerName, @Nullable TimeValue masterTimeout, String templateName) {
        super(resourceOwnerName, masterTimeout, PARAMETERS);
        this.templateName = Objects.requireNonNull(templateName);
    }

    @Override
    protected void doCheck(RestClient client, ActionListener<Boolean> listener) {
        this.versionCheckForResource(client, listener, logger, "/_template", this.templateName, "monitoring template", this.resourceOwnerName, "monitoring cluster", XContentType.JSON.xContent(), 8120099);
    }

    @Override
    protected void doPublish(RestClient client, ActionListener<HttpResource.ResourcePublishResult> listener) {
        listener.onResponse((Object)HttpResource.ResourcePublishResult.notReady("waiting for remote monitoring cluster to install appropriate template [" + this.templateName + "] (version mismatch or missing)"));
    }

    static {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("filter_path", "*.version");
        PARAMETERS = Collections.unmodifiableMap(parameters);
    }
}

