/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.cluster;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.Build;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequestBuilder;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackUsageAction;
import org.elasticsearch.xpack.core.action.XPackUsageResponse;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.TimeoutUtils;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterStatsMonitoringDoc;

public class ClusterStatsCollector
extends Collector {
    public static final Setting<TimeValue> CLUSTER_STATS_TIMEOUT = ClusterStatsCollector.collectionTimeoutSetting("cluster.stats.timeout");
    private final Settings settings;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final LicenseService licenseService;
    private final Client client;

    public ClusterStatsCollector(Settings settings, ClusterService clusterService, XPackLicenseState licenseState, Client client, LicenseService licenseService, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster_stats", clusterService, CLUSTER_STATS_TIMEOUT, licenseState);
        this.settings = settings;
        this.client = client;
        this.licenseService = licenseService;
        this.indexNameExpressionResolver = Objects.requireNonNull(indexNameExpressionResolver);
    }

    @Override
    protected boolean shouldCollect(boolean isElectedMaster) {
        return isElectedMaster;
    }

    @Override
    protected Collection<MonitoringDoc> doCollect(MonitoringDoc.Node node, long interval, ClusterState clusterState) {
        ClusterStatsResponse clusterStats = (ClusterStatsResponse)((ClusterStatsRequestBuilder)this.client.admin().cluster().prepareClusterStats().setTimeout(this.getCollectionTimeout())).get();
        TimeoutUtils.ensureNoTimeouts(this.getCollectionTimeout(), clusterStats);
        String clusterName = this.clusterService.getClusterName().value();
        String clusterUuid = ClusterStatsCollector.clusterUuid(clusterState);
        String version = Build.current().version();
        License license = this.licenseService.getLicense();
        List xpackUsage = (List)this.collect(() -> ((XPackUsageResponse)this.client.execute(XPackUsageAction.INSTANCE, (ActionRequest)new XPackUsageRequest(this.getCollectionTimeout())).actionGet(this.getCollectionTimeout())).getUsages());
        boolean apmIndicesExist = this.doAPMIndicesExist(clusterState);
        boolean clusterNeedsTLSEnabled = license != null && license.operationMode() == License.OperationMode.TRIAL && this.settings.hasValue(XPackSettings.SECURITY_ENABLED.getKey()) && (Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings) != false && (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(this.settings) == false;
        return Collections.singleton(new ClusterStatsMonitoringDoc(clusterUuid, ClusterStatsCollector.timestamp(), interval, node, clusterName, version, clusterStats.getStatus(), license, apmIndicesExist, xpackUsage, clusterStats, clusterState, clusterNeedsTLSEnabled));
    }

    boolean doAPMIndicesExist(ClusterState clusterState) {
        try {
            Index[] indices = this.indexNameExpressionResolver.concreteIndices(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{"apm-*"});
            return indices.length > 0;
        }
        catch (IllegalArgumentException | IndexNotFoundException e) {
            return false;
        }
    }

    @Nullable
    private <T> T collect(Supplier<T> supplier) {
        try {
            return (T)supplier.get();
        }
        catch (ElasticsearchSecurityException e) {
            if (!LicenseUtils.isLicenseExpiredException((ElasticsearchSecurityException)e)) {
                throw e;
            }
            this.logger.trace(() -> Strings.format((String)"collector [%s] - unable to collect data because of expired license", (Object[])new Object[]{this.name()}), (Throwable)e);
            return null;
        }
    }
}

