/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.frozen;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.engine.frozen.FrozenEngine;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.frozen.FrozenIndicesFeatureSetUsage;

public class FrozenIndicesUsageTransportAction
extends XPackUsageFeatureTransportAction {
    @Inject
    public FrozenIndicesUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(XPackUsageFeatureAction.FROZEN_INDICES.name(), transportService, clusterService, threadPool, actionFilters);
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        int numFrozenIndices = 0;
        for (IndexMetadata indexMetadata : state.metadata()) {
            if (!((Boolean)FrozenEngine.INDEX_FROZEN.get(indexMetadata.getSettings())).booleanValue()) continue;
            ++numFrozenIndices;
        }
        listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureUsage)new FrozenIndicesFeatureSetUsage(true, true, numFrozenIndices)));
    }
}

