/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;
import org.elasticsearch.compute.operator.topn.ValueExtractor;

abstract class ValueExtractorForFloat
implements ValueExtractor {
    protected final boolean inKey;

    static ValueExtractorForFloat extractorFor(TopNEncoder encoder, boolean inKey, FloatBlock block) {
        FloatVector vector = block.asVector();
        if (vector != null) {
            return new ForVector(encoder, inKey, vector);
        }
        return new ForBlock(encoder, inKey, block);
    }

    ValueExtractorForFloat(TopNEncoder encoder, boolean inKey) {
        assert (encoder == TopNEncoder.DEFAULT_UNSORTABLE) : encoder.toString();
        this.inKey = inKey;
    }

    protected final void writeCount(BreakingBytesRefBuilder values, int count) {
        TopNEncoder.DEFAULT_UNSORTABLE.encodeVInt(count, values);
    }

    protected final void actualWriteValue(BreakingBytesRefBuilder values, float value) {
        TopNEncoder.DEFAULT_UNSORTABLE.encodeFloat(value, values);
    }

    static class ForVector
    extends ValueExtractorForFloat {
        private final FloatVector vector;

        ForVector(TopNEncoder encoder, boolean inKey, FloatVector vector) {
            super(encoder, inKey);
            this.vector = vector;
        }

        @Override
        public void writeValue(BreakingBytesRefBuilder values, int position) {
            this.writeCount(values, 1);
            if (this.inKey) {
                return;
            }
            this.actualWriteValue(values, this.vector.getFloat(position));
        }
    }

    static class ForBlock
    extends ValueExtractorForFloat {
        private final FloatBlock block;

        ForBlock(TopNEncoder encoder, boolean inKey, FloatBlock block) {
            super(encoder, inKey);
            this.block = block;
        }

        @Override
        public void writeValue(BreakingBytesRefBuilder values, int position) {
            int size = this.block.getValueCount(position);
            this.writeCount(values, size);
            if (size == 1 && this.inKey) {
                return;
            }
            int start = this.block.getFirstValueIndex(position);
            int end = start + size;
            for (int i = start; i < end; ++i) {
                this.actualWriteValue(values, this.block.getFloat(i));
            }
        }
    }
}

