/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.ConcatFunctionProcessor;
import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class ConcatFunctionPipe
extends Pipe {
    private final List<Pipe> values;

    public ConcatFunctionPipe(Source source, Expression expression, List<Pipe> values) {
        super(source, expression, values);
        this.values = values;
    }

    public final ConcatFunctionPipe replaceChildren(List<Pipe> newChildren) {
        return new ConcatFunctionPipe(this.source(), this.expression(), newChildren);
    }

    public final Pipe resolveAttributes(Pipe.AttributeResolver resolver) {
        ArrayList<Pipe> newValues = new ArrayList<Pipe>(this.values.size());
        for (Pipe v : this.values) {
            newValues.add(v.resolveAttributes(resolver));
        }
        if (newValues == this.values) {
            return this;
        }
        return (Pipe)this.replaceChildrenSameSize(newValues);
    }

    public boolean supportedByAggsOnlyQuery() {
        for (Pipe p : this.values) {
            if (p.supportedByAggsOnlyQuery()) continue;
            return false;
        }
        return true;
    }

    public boolean resolved() {
        for (Pipe p : this.values) {
            if (p.resolved()) continue;
            return false;
        }
        return true;
    }

    public final void collectFields(QlSourceBuilder sourceBuilder) {
        for (Pipe v : this.values) {
            v.collectFields(sourceBuilder);
        }
    }

    protected NodeInfo<ConcatFunctionPipe> info() {
        return NodeInfo.create((Node)this, ConcatFunctionPipe::new, (Object)this.expression(), this.values);
    }

    public ConcatFunctionProcessor asProcessor() {
        ArrayList<Processor> processors = new ArrayList<Processor>(this.values.size());
        for (Pipe p : this.values) {
            processors.add(p.asProcessor());
        }
        return new ConcatFunctionProcessor(processors);
    }

    List<Pipe> values() {
        return this.values;
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.values(), ((ConcatFunctionPipe)((Object)obj)).values());
    }
}

