/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.pipeline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.aggregations.pipeline.MovingFunctionScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class MovFnPipelineAggregator
extends PipelineAggregator {
    private final DocValueFormat formatter;
    private final BucketHelpers.GapPolicy gapPolicy;
    private final Script script;
    private final int window;
    private final int shift;

    MovFnPipelineAggregator(String name, String bucketsPath, Script script, int window, int shift, DocValueFormat formatter, BucketHelpers.GapPolicy gapPolicy, Map<String, Object> metadata) {
        super(name, new String[]{bucketsPath}, metadata);
        this.script = script;
        this.formatter = formatter;
        this.gapPolicy = gapPolicy;
        this.window = window;
        this.shift = shift;
    }

    public InternalAggregation reduce(InternalAggregation aggregation, AggregationReduceContext reduceContext) {
        InternalMultiBucketAggregation histo = (InternalMultiBucketAggregation)aggregation;
        List buckets = histo.getBuckets();
        HistogramFactory factory = (HistogramFactory)histo;
        ArrayList<InternalMultiBucketAggregation.InternalBucket> newBuckets = new ArrayList<InternalMultiBucketAggregation.InternalBucket>();
        MovingFunctionScript.Factory scriptFactory = (MovingFunctionScript.Factory)reduceContext.scriptService().compile(this.script, MovingFunctionScript.CONTEXT);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        if (this.script.getParams() != null) {
            vars.putAll(this.script.getParams());
        }
        MovingFunctionScript executableScript = scriptFactory.newInstance();
        List<Double> values = buckets.stream().map(b -> BucketHelpers.resolveBucketValue((MultiBucketsAggregation)histo, (InternalMultiBucketAggregation.InternalBucket)b, (String)this.bucketsPaths()[0], (BucketHelpers.GapPolicy)this.gapPolicy)).filter(v -> v != null && !v.isNaN()).toList();
        int index = 0;
        for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
            Double thisBucketValue = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)histo, (InternalMultiBucketAggregation.InternalBucket)bucket, (String)this.bucketsPaths()[0], (BucketHelpers.GapPolicy)this.gapPolicy);
            InternalMultiBucketAggregation.InternalBucket newBucket = bucket;
            if (thisBucketValue != null && !thisBucketValue.isNaN()) {
                int fromIndex = MovFnPipelineAggregator.clamp(index - this.window + this.shift, values);
                int toIndex = MovFnPipelineAggregator.clamp(index + this.shift, values);
                double result = executableScript.execute(vars, values.subList(fromIndex, toIndex).stream().mapToDouble(Double::doubleValue).toArray());
                List aggs = StreamSupport.stream(bucket.getAggregations().spliterator(), false).map(InternalAggregation.class::cast).collect(Collectors.toCollection(ArrayList::new));
                aggs.add(new InternalSimpleValue(this.name(), result, this.formatter, this.metadata()));
                newBucket = factory.createBucket(factory.getKey((MultiBucketsAggregation.Bucket)bucket), bucket.getDocCount(), InternalAggregations.from((List)aggs));
                ++index;
            }
            newBuckets.add(newBucket);
        }
        return factory.createAggregation(newBuckets);
    }

    private static int clamp(int index, List<Double> list) {
        if (index < 0) {
            return 0;
        }
        return Math.min(index, list.size());
    }
}

