/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.elasticsearch.aggregations.bucket.histogram.AutoDateHistogramAggregator;
import org.elasticsearch.aggregations.bucket.histogram.AutoDateHistogramAggregatorSupplier;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public final class AutoDateHistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(AutoDateHistogramAggregator.class);
    private final AutoDateHistogramAggregatorSupplier aggregatorSupplier;
    private final int numBuckets;
    private final AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(AutoDateHistogramAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.DATE, CoreValuesSourceType.NUMERIC), AutoDateHistogramAggregator::build, true);
        builder.register(AutoDateHistogramAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)CoreValuesSourceType.BOOLEAN, (name, factories, targetBuckets, roundingInfos, valuesSourceConfig, context, parent, cardinality, metadata) -> {
            DEPRECATION_LOGGER.warn(DeprecationCategory.AGGREGATIONS, "auto-date-histogram-boolean", "Running AutoIntervalDateHistogram aggregations on [boolean] fields is deprecated", new Object[0]);
            return AutoDateHistogramAggregator.build(name, factories, targetBuckets, roundingInfos, valuesSourceConfig, context, parent, cardinality, metadata);
        }, true);
    }

    public AutoDateHistogramAggregatorFactory(String name, ValuesSourceConfig config, int numBuckets, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, AutoDateHistogramAggregatorSupplier aggregatorSupplier) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.aggregatorSupplier = aggregatorSupplier;
        this.numBuckets = numBuckets;
        this.roundingInfos = roundingInfos;
    }

    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.aggregatorSupplier.build(this.name, this.factories, this.numBuckets, this.roundingInfos, this.config, this.context, parent, cardinality, metadata);
    }

    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        return AutoDateHistogramAggregator.build(this.name, this.factories, this.numBuckets, this.roundingInfos, this.config, this.context, parent, CardinalityUpperBound.NONE, metadata);
    }
}

