/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.LockModeType;
import javax.persistence.TypedQuery;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import org.opensaml.storage.AbstractStorageService;
import org.opensaml.storage.StorageCapabilitiesEx;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.VersionMismatchException;
import org.opensaml.storage.impl.JPAStorageRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAStorageService
extends AbstractStorageService
implements StorageCapabilitiesEx {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JPAStorageService.class);
    @Nonnull
    private final EntityManagerFactory entityManagerFactory;
    @NonNegative
    private int transactionRetry;

    public JPAStorageService(@Nonnull EntityManagerFactory factory) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CLASS, (String)"JPAStorageService", null, (String)"JDBCStorageService");
        this.entityManagerFactory = (EntityManagerFactory)Constraint.isNotNull((Object)factory, (String)"EntityManagerFactory cannot be null");
        this.setContextSize(255);
        this.setKeySize(255);
        this.setValueSize(Integer.MAX_VALUE);
        this.setTransactionRetry(3);
    }

    public int getTransactionRetry() {
        return this.transactionRetry;
    }

    @Deprecated(forRemoval=true, since="4.2")
    void setTransactionRetry(int retry) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.PROPERTY, (String)"transactionRetry", null, (String)"transactionRetries");
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.transactionRetry = Constraint.isGreaterThanOrEqual((int)0, (int)retry, (String)"Transaction retry must be greater than or equal to zero");
    }

    public void setTransactionRetries(int retry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.transactionRetry = Constraint.isGreaterThanOrEqual((int)0, (int)retry, (String)"Transaction retries must be greater than or equal to zero");
    }

    public boolean isServerSide() {
        return true;
    }

    public boolean isClustered() {
        return true;
    }

    protected void doDestroy() {
        if (this.entityManagerFactory.isOpen()) {
            this.entityManagerFactory.close();
        }
        super.doDestroy();
    }

    /*
     * Exception decompiling
     */
    public boolean create(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    @NonnullElements
    public List<?> readAll() throws IOException {
        EntityManager manager = null;
        try {
            manager = this.entityManagerFactory.createEntityManager();
            List<StorageRecord> list = this.executeNamedQuery(manager, "JPAStorageRecord.findAll", null, StorageRecord.class, LockModeType.PESSIMISTIC_READ);
            return list;
        }
        finally {
            this.closeEntityManager(manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @NonnullElements
    public List<?> readAll(@Nonnull @NotEmpty String context) throws IOException {
        EntityManager manager = null;
        try {
            manager = this.entityManagerFactory.createEntityManager();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("context", context);
            List<StorageRecord> list = this.executeNamedQuery(manager, "JPAStorageRecord.findByContext", params, StorageRecord.class, LockModeType.PESSIMISTIC_READ);
            return list;
        }
        finally {
            this.closeEntityManager(manager);
        }
    }

    @Nonnull
    @NonnullElements
    public List<String> readContexts() throws IOException {
        EntityManager manager = null;
        try {
            manager = this.entityManagerFactory.createEntityManager();
            List<String> list = this.executeNamedQuery(manager, "JPAStorageRecord.findAllContexts", null, String.class, LockModeType.OPTIMISTIC);
            return list;
        }
        finally {
            this.closeEntityManager(manager);
        }
    }

    @Nullable
    public <T> StorageRecord<T> read(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException {
        return (StorageRecord)this.readImpl(context, key, null).getSecond();
    }

    @Nonnull
    public <T> Pair<Long, StorageRecord<T>> read(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Positive long version) throws IOException {
        return this.readImpl(context, key, version);
    }

    @Nonnull
    protected <T> Pair<Long, StorageRecord<T>> readImpl(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Positive Long version) throws IOException {
        JPAStorageRecord entity;
        EntityTransaction transaction;
        EntityManager manager;
        block9: {
            block8: {
                block7: {
                    manager = null;
                    transaction = null;
                    manager = this.entityManagerFactory.createEntityManager();
                    transaction = manager.getTransaction();
                    transaction.begin();
                    entity = (JPAStorageRecord)((Object)manager.find(JPAStorageRecord.class, (Object)new JPAStorageRecord.RecordId(context, key), LockModeType.PESSIMISTIC_READ));
                    if (entity != null) break block7;
                    this.log.debug("Read failed, key '{}' not found in context '{}'", (Object)key, (Object)context);
                    Pair pair = new Pair();
                    this.commitTransaction(transaction);
                    this.closeEntityManager(manager);
                    return pair;
                }
                Long exp = entity.getExpiration();
                if (exp == null || System.currentTimeMillis() < exp) break block8;
                this.log.debug("Read failed, key '{}' expired in context '{}'", (Object)key, (Object)context);
                Pair pair = new Pair();
                this.commitTransaction(transaction);
                this.closeEntityManager(manager);
                return pair;
            }
            if (version == null || entity.getVersion() != version.longValue()) break block9;
            Pair pair = new Pair((Object)version, null);
            this.commitTransaction(transaction);
            this.closeEntityManager(manager);
            return pair;
        }
        try {
            Pair pair = new Pair((Object)entity.getVersion(), (Object)entity);
            this.commitTransaction(transaction);
            this.closeEntityManager(manager);
            return pair;
        }
        catch (Exception e) {
            try {
                this.log.error("Error reading record '{}' in context '{}'", new Object[]{key, context, e});
                this.rollbackTransaction(transaction);
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.commitTransaction(transaction);
                this.closeEntityManager(manager);
                throw throwable;
            }
        }
    }

    public boolean update(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException {
        try {
            return this.updateImpl(null, context, key, value, expiration) != null;
        }
        catch (VersionMismatchException e) {
            throw new IllegalStateException("Unexpected exception thrown by update.", e);
        }
    }

    @Nullable
    public Long updateWithVersion(@Positive long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException, VersionMismatchException {
        return this.updateImpl(version, context, key, value, expiration);
    }

    public boolean updateExpiration(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable @Positive Long expiration) throws IOException {
        try {
            return this.updateImpl(null, context, key, null, expiration) != null;
        }
        catch (VersionMismatchException e) {
            throw new IllegalStateException("Unexpected exception thrown by update.", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    protected Long updateImpl(@Nullable Long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable String value, @Nullable @Positive Long expiration) throws IOException, VersionMismatchException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean deleteWithVersion(@Positive long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException, VersionMismatchException {
        return this.deleteImpl(version, context, key);
    }

    public boolean delete(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException {
        try {
            return this.deleteImpl(null, context, key);
        }
        catch (VersionMismatchException e) {
            throw new IllegalStateException("Unexpected exception thrown by delete.", e);
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean deleteImpl(@Nullable @Positive Long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException, VersionMismatchException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void updateContextExpiration(@Nonnull @NotEmpty String context, @Nullable @Positive Long expiration) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteContext(@Nonnull @NotEmpty String context) throws IOException {
        this.deleteContextImpl(context, null);
        this.log.debug("Deleted all entities in context '{}'", (Object)context);
    }

    public void reap(@Nonnull @NotEmpty String context) throws IOException {
        this.deleteContextImpl(context, System.currentTimeMillis());
        this.log.debug("Reaped all entities in context '{}'", (Object)context);
    }

    /*
     * Exception decompiling
     */
    protected void deleteContextImpl(@Nonnull @NotEmpty String context, @Nonnull Long expiration) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected void deleteImpl(@Nonnull Long expiration) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> List<T> executeNamedQuery(@Nonnull EntityManager manager, @Nonnull @NotEmpty String query, @Nonnull Map<String, Object> params, @Nonnull Class<T> clazz, @Nonnull LockModeType lockMode) throws IOException {
        ArrayList results = new ArrayList();
        EntityTransaction transaction = null;
        try {
            transaction = manager.getTransaction();
            transaction.begin();
            TypedQuery queryResults = manager.createNamedQuery(query, clazz);
            queryResults.setLockMode(lockMode);
            if (params != null && !params.isEmpty()) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    queryResults.setParameter(entry.getKey(), entry.getValue());
                }
            }
            results.addAll(queryResults.getResultList());
        }
        catch (Exception e) {
            this.log.error("Error executing named query", (Throwable)e);
            this.rollbackTransaction(transaction);
            throw new IOException(e);
        }
        finally {
            this.commitTransaction(transaction);
        }
        return results;
    }

    @Nullable
    protected TimerTask getCleanupTask() {
        return new TimerTask(){

            @Override
            public void run() {
                Long now = System.currentTimeMillis();
                JPAStorageService.this.log.debug("Running cleanup task at {}", (Object)now);
                try {
                    JPAStorageService.this.deleteImpl(now);
                }
                catch (IOException e) {
                    JPAStorageService.this.log.error("Error running cleanup task for {}", (Object)now, (Object)e);
                }
                JPAStorageService.this.log.debug("Finished cleanup task for {}", (Object)now);
            }
        };
    }

    private void commitTransaction(@Nullable EntityTransaction transaction) {
        if (transaction != null && transaction.isActive() && !transaction.getRollbackOnly()) {
            try {
                transaction.commit();
            }
            catch (Exception e) {
                this.log.error("Error committing transaction", (Throwable)e);
            }
        }
    }

    private void rollbackTransaction(@Nullable EntityTransaction transaction) {
        if (transaction != null && transaction.isActive()) {
            try {
                transaction.rollback();
            }
            catch (Exception e) {
                this.log.error("Error rolling back transaction", (Throwable)e);
            }
        }
    }

    private void closeEntityManager(@Nullable EntityManager manager) {
        if (manager != null && manager.isOpen()) {
            try {
                manager.close();
            }
            catch (Exception e) {
                this.log.error("Error closing entity manager", (Throwable)e);
            }
        }
    }
}

