/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action.repositories;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.action.repositories.PutCcrRestoreSessionRequest;
import org.elasticsearch.xpack.ccr.repository.CcrRestoreSourceService;

public class PutCcrRestoreSessionAction
extends ActionType<PutCcrRestoreSessionResponse> {
    public static final PutCcrRestoreSessionAction INTERNAL_INSTANCE = new PutCcrRestoreSessionAction();
    public static final String INTERNAL_NAME = "internal:admin/ccr/restore/session/put";
    public static final String NAME = "indices:internal/admin/ccr/restore/session/put";
    public static final PutCcrRestoreSessionAction INSTANCE = new PutCcrRestoreSessionAction("indices:internal/admin/ccr/restore/session/put");
    public static final RemoteClusterActionType<PutCcrRestoreSessionResponse> REMOTE_TYPE = new RemoteClusterActionType("indices:internal/admin/ccr/restore/session/put", PutCcrRestoreSessionResponse::new);
    public static final RemoteClusterActionType<PutCcrRestoreSessionResponse> REMOTE_INTERNAL_TYPE = new RemoteClusterActionType("internal:admin/ccr/restore/session/put", PutCcrRestoreSessionResponse::new);

    private PutCcrRestoreSessionAction() {
        super(INTERNAL_NAME);
    }

    private PutCcrRestoreSessionAction(String name) {
        super(name);
    }

    public static class PutCcrRestoreSessionResponse
    extends ActionResponse {
        private final DiscoveryNode node;
        private final Store.MetadataSnapshot storeFileMetadata;
        private final long mappingVersion;

        PutCcrRestoreSessionResponse(DiscoveryNode node, Store.MetadataSnapshot storeFileMetadata, long mappingVersion) {
            this.node = node;
            this.storeFileMetadata = storeFileMetadata;
            this.mappingVersion = mappingVersion;
        }

        PutCcrRestoreSessionResponse(StreamInput in) throws IOException {
            super(in);
            this.node = new DiscoveryNode(in);
            this.storeFileMetadata = Store.MetadataSnapshot.readFrom((StreamInput)in);
            this.mappingVersion = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.node.writeTo(out);
            this.storeFileMetadata.writeTo(out);
            out.writeVLong(this.mappingVersion);
        }

        public DiscoveryNode getNode() {
            return this.node;
        }

        public Store.MetadataSnapshot getStoreFileMetadata() {
            return this.storeFileMetadata;
        }

        public long getMappingVersion() {
            return this.mappingVersion;
        }
    }

    public static class TransportAction
    extends TransportPutCcrRestoreSessionAction {
        @Inject
        public TransportAction(ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver resolver, TransportService transportService, IndicesService indicesService, CcrRestoreSourceService ccrRestoreService) {
            super(PutCcrRestoreSessionAction.NAME, threadPool, clusterService, actionFilters, resolver, transportService, indicesService, ccrRestoreService);
        }
    }

    public static class InternalTransportAction
    extends TransportPutCcrRestoreSessionAction {
        @Inject
        public InternalTransportAction(ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver resolver, TransportService transportService, IndicesService indicesService, CcrRestoreSourceService ccrRestoreService) {
            super(PutCcrRestoreSessionAction.INTERNAL_NAME, threadPool, clusterService, actionFilters, resolver, transportService, indicesService, ccrRestoreService);
        }
    }

    static abstract class TransportPutCcrRestoreSessionAction
    extends TransportSingleShardAction<PutCcrRestoreSessionRequest, PutCcrRestoreSessionResponse> {
        private final IndicesService indicesService;
        private final CcrRestoreSourceService ccrRestoreService;

        private TransportPutCcrRestoreSessionAction(String actionName, ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver resolver, TransportService transportService, IndicesService indicesService, CcrRestoreSourceService ccrRestoreService) {
            super(actionName, threadPool, clusterService, transportService, actionFilters, resolver, PutCcrRestoreSessionRequest::new, (Executor)threadPool.executor("generic"));
            this.indicesService = indicesService;
            this.ccrRestoreService = ccrRestoreService;
        }

        protected PutCcrRestoreSessionResponse shardOperation(PutCcrRestoreSessionRequest request, ShardId shardId) throws IOException {
            IndexShard indexShard = (IndexShard)this.indicesService.getShardOrNull(shardId);
            if (indexShard == null) {
                throw new ShardNotFoundException(shardId);
            }
            Store.MetadataSnapshot storeFileMetadata = this.ccrRestoreService.openSession(request.getSessionUUID(), indexShard);
            long mappingVersion = indexShard.indexSettings().getIndexMetadata().getMappingVersion();
            return new PutCcrRestoreSessionResponse(this.clusterService.localNode(), storeFileMetadata, mappingVersion);
        }

        protected Writeable.Reader<PutCcrRestoreSessionResponse> getResponseReader() {
            return PutCcrRestoreSessionResponse::new;
        }

        protected boolean resolveIndex(PutCcrRestoreSessionRequest request) {
            return false;
        }

        protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
            ShardId shardId = ((PutCcrRestoreSessionRequest)request.request()).getShardId();
            return state.routingTable().shardRoutingTable(shardId).primaryShardIt();
        }
    }
}

