/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.simdvec;

import org.apache.lucene.index.VectorSimilarityFunction;

public enum VectorSimilarityType {
    COSINE,
    DOT_PRODUCT,
    EUCLIDEAN,
    MAXIMUM_INNER_PRODUCT;


    public static VectorSimilarityType of(VectorSimilarityFunction func) {
        return switch (func) {
            default -> throw new IncompatibleClassChangeError();
            case VectorSimilarityFunction.EUCLIDEAN -> EUCLIDEAN;
            case VectorSimilarityFunction.COSINE -> COSINE;
            case VectorSimilarityFunction.DOT_PRODUCT -> DOT_PRODUCT;
            case VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT -> MAXIMUM_INNER_PRODUCT;
        };
    }

    public static VectorSimilarityFunction of(VectorSimilarityType func) {
        return switch (func) {
            default -> throw new IncompatibleClassChangeError();
            case EUCLIDEAN -> VectorSimilarityFunction.EUCLIDEAN;
            case COSINE -> VectorSimilarityFunction.COSINE;
            case DOT_PRODUCT -> VectorSimilarityFunction.DOT_PRODUCT;
            case MAXIMUM_INNER_PRODUCT -> VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT;
        };
    }
}

