/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public class MemoryUtil {
    private static final @UnknownKeyFor @NonNull @Initialized Logger logger = LoggerFactory.getLogger(MemoryUtil.class);
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Constructor<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> DIRECT_BUFFER_CONSTRUCTOR;
    public static final @UnknownKeyFor @NonNull @Initialized Unsafe UNSAFE;
    public static final @UnknownKeyFor @NonNull @Initialized long BYTE_ARRAY_BASE_OFFSET;
    static final @UnknownKeyFor @NonNull @Initialized long BYTE_BUFFER_ADDRESS_OFFSET;
    public static final @UnknownKeyFor @NonNull @Initialized boolean LITTLE_ENDIAN;
    private static final @UnknownKeyFor @NonNull @Initialized int majorVersion;

    public static @UnknownKeyFor @NonNull @Initialized long getByteBufferAddress(@UnknownKeyFor @NonNull @Initialized ByteBuffer buf) {
        return UNSAFE.getLong(buf, BYTE_BUFFER_ADDRESS_OFFSET);
    }

    private MemoryUtil() {
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteBuffer directBuffer(@UnknownKeyFor @NonNull @Initialized long address, @UnknownKeyFor @NonNull @Initialized int capacity) {
        if (DIRECT_BUFFER_CONSTRUCTOR != null) {
            if (capacity < 0) {
                throw new IllegalArgumentException("Capacity is negative, has to be positive or 0");
            }
            try {
                return (ByteBuffer)DIRECT_BUFFER_CONSTRUCTOR.newInstance(address, capacity);
            }
            catch (Throwable cause) {
                throw new Error(cause);
            }
        }
        throw new UnsupportedOperationException("sun.misc.Unsafe or java.nio.DirectByteBuffer.<init>(long, int) not available");
    }

    public static void copyMemory(@Nullable @UnknownKeyFor @Initialized Object srcBase, @UnknownKeyFor @NonNull @Initialized long srcOffset, @Nullable @UnknownKeyFor @Initialized Object destBase, @UnknownKeyFor @NonNull @Initialized long destOffset, @UnknownKeyFor @NonNull @Initialized long bytes) {
        UNSAFE.copyMemory(srcBase, srcOffset, destBase, destOffset, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
        majorVersion = Integer.parseInt(System.getProperty("java.specification.version").split("\\D+")[0]);
        try {
            Constructor directBufferConstructor;
            Object maybeUnsafe = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized Object run() {
                    try {
                        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                        unsafeField.setAccessible(true);
                        return unsafeField.get(null);
                    }
                    catch (Throwable e) {
                        return e;
                    }
                }
            });
            if (maybeUnsafe instanceof Throwable) {
                throw (Throwable)maybeUnsafe;
            }
            UNSAFE = (Unsafe)maybeUnsafe;
            BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            Field addressField = Buffer.class.getDeclaredField("address");
            addressField.setAccessible(true);
            BYTE_BUFFER_ADDRESS_OFFSET = UNSAFE.objectFieldOffset(addressField);
            long address = -1L;
            final ByteBuffer direct = ByteBuffer.allocateDirect(1);
            try {
                Object maybeDirectBufferConstructor = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized Object run() {
                        try {
                            Constructor<?> constructor = majorVersion >= 21 ? direct.getClass().getDeclaredConstructor(Long.TYPE, Long.TYPE) : direct.getClass().getDeclaredConstructor(Long.TYPE, Integer.TYPE);
                            constructor.setAccessible(true);
                            logger.debug("Constructor for direct buffer found and made accessible");
                            return constructor;
                        }
                        catch (NoSuchMethodException e) {
                            logger.debug("Cannot get constructor for direct buffer allocation", (Throwable)e);
                            return e;
                        }
                        catch (SecurityException e) {
                            logger.debug("Cannot get constructor for direct buffer allocation", (Throwable)e);
                            return e;
                        }
                    }
                });
                if (maybeDirectBufferConstructor instanceof Constructor) {
                    address = UNSAFE.allocateMemory(1L);
                    try {
                        ((Constructor)maybeDirectBufferConstructor).newInstance(address, 1);
                        directBufferConstructor = (Constructor)maybeDirectBufferConstructor;
                        logger.debug("direct buffer constructor: available");
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        logger.warn("unable to instantiate a direct buffer via constructor", (Throwable)e);
                        directBufferConstructor = null;
                    }
                } else {
                    logger.debug("direct buffer constructor: unavailable", (Throwable)maybeDirectBufferConstructor);
                    directBufferConstructor = null;
                }
            }
            finally {
                if (address != -1L) {
                    UNSAFE.freeMemory(address);
                }
            }
            DIRECT_BUFFER_CONSTRUCTOR = directBufferConstructor;
        }
        catch (Throwable e) {
            RuntimeException failure = new RuntimeException("Failed to initialize MemoryUtil. You must start Java with `--add-opens=java.base/java.nio=org.apache.arrow.memory.core,ALL-UNNAMED` (See https://arrow.apache.org/docs/java/install.html)", e);
            failure.printStackTrace();
            throw failure;
        }
    }
}

