/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.math;

import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.MathProcessor;

public abstract class MathFunction
extends UnaryScalarFunction {
    protected MathFunction(Source source) {
        super(source);
    }

    protected MathFunction(Source source, Expression field) {
        super(source, field);
    }

    public boolean foldable() {
        return this.field().foldable();
    }

    public Object fold() {
        return this.operation().apply(this.field().fold());
    }

    public String processScript(String template) {
        return super.processScript(String.format(Locale.ROOT, "{sql}.%s(%s)", ((Object)((Object)this)).getClass().getSimpleName().toLowerCase(Locale.ROOT), template));
    }

    public DataType dataType() {
        return DataTypes.DOUBLE;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isNumeric((Expression)this.field(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    protected Processor makeProcessor() {
        return new MathProcessor(this.operation());
    }

    protected abstract MathProcessor.MathOperation operation();

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        MathFunction other = (MathFunction)((Object)obj);
        return Objects.equals(other.field(), this.field());
    }

    public int hashCode() {
        return Objects.hash(this.field());
    }
}

