/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;

public enum AuditLevel {
    ANONYMOUS_ACCESS_DENIED,
    AUTHENTICATION_FAILED,
    REALM_AUTHENTICATION_FAILED,
    ACCESS_GRANTED,
    ACCESS_DENIED,
    TAMPERED_REQUEST,
    CONNECTION_GRANTED,
    CONNECTION_DENIED,
    SYSTEM_ACCESS_GRANTED,
    SECURITY_CONFIG_CHANGE,
    AUTHENTICATION_SUCCESS,
    RUN_AS_GRANTED,
    RUN_AS_DENIED;


    static EnumSet<AuditLevel> parse(List<String> levels) {
        EnumSet<AuditLevel> enumSet = EnumSet.noneOf(AuditLevel.class);
        block32: for (String level : levels) {
            String lowerCaseLevel;
            switch (lowerCaseLevel = level.trim().toLowerCase(Locale.ROOT)) {
                case "_all": {
                    enumSet.addAll(Arrays.asList(AuditLevel.values()));
                    continue block32;
                }
                case "anonymous_access_denied": {
                    enumSet.add(ANONYMOUS_ACCESS_DENIED);
                    continue block32;
                }
                case "authentication_failed": {
                    enumSet.add(AUTHENTICATION_FAILED);
                    continue block32;
                }
                case "realm_authentication_failed": {
                    enumSet.add(REALM_AUTHENTICATION_FAILED);
                    continue block32;
                }
                case "access_granted": {
                    enumSet.add(ACCESS_GRANTED);
                    continue block32;
                }
                case "access_denied": {
                    enumSet.add(ACCESS_DENIED);
                    continue block32;
                }
                case "tampered_request": {
                    enumSet.add(TAMPERED_REQUEST);
                    continue block32;
                }
                case "connection_granted": {
                    enumSet.add(CONNECTION_GRANTED);
                    continue block32;
                }
                case "connection_denied": {
                    enumSet.add(CONNECTION_DENIED);
                    continue block32;
                }
                case "system_access_granted": {
                    enumSet.add(SYSTEM_ACCESS_GRANTED);
                    continue block32;
                }
                case "security_config_change": {
                    enumSet.add(SECURITY_CONFIG_CHANGE);
                    continue block32;
                }
                case "authentication_success": {
                    enumSet.add(AUTHENTICATION_SUCCESS);
                    continue block32;
                }
                case "run_as_granted": {
                    enumSet.add(RUN_AS_GRANTED);
                    continue block32;
                }
                case "run_as_denied": {
                    enumSet.add(RUN_AS_DENIED);
                    continue block32;
                }
            }
            throw new IllegalArgumentException("invalid event name specified [" + level + "]");
        }
        return enumSet;
    }

    public static EnumSet<AuditLevel> parse(List<String> includeLevels, List<String> excludeLevels) {
        EnumSet<AuditLevel> included = AuditLevel.parse(includeLevels);
        EnumSet<AuditLevel> excluded = AuditLevel.parse(excludeLevels);
        included.removeAll(excluded);
        return included;
    }
}

