/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.Driver;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.compute.operator.DriverTaskRunner;
import org.elasticsearch.compute.operator.exchange.ExchangeService;
import org.elasticsearch.compute.operator.exchange.ExchangeSourceHandler;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.enrich.EnrichLookupService;
import org.elasticsearch.xpack.esql.enrich.LookupFromIndexService;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSinkExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.OutputExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.EsPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.LocalExecutionPlanner;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.plugin.ClusterComputeHandler;
import org.elasticsearch.xpack.esql.plugin.ComputeContext;
import org.elasticsearch.xpack.esql.plugin.ComputeListener;
import org.elasticsearch.xpack.esql.plugin.ComputeResponse;
import org.elasticsearch.xpack.esql.plugin.DataNodeComputeHandler;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;
import org.elasticsearch.xpack.esql.plugin.ReinitializingSourceProvider;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.session.Result;

public class ComputeService {
    public static final String DATA_ACTION_NAME = "indices:data/read/esql/data";
    public static final String CLUSTER_ACTION_NAME = "indices:data/read/esql/cluster";
    private static final String LOCAL_CLUSTER = "";
    private static final Logger LOGGER = LogManager.getLogger(ComputeService.class);
    private final SearchService searchService;
    private final BigArrays bigArrays;
    private final BlockFactory blockFactory;
    private final TransportService transportService;
    private final DriverTaskRunner driverRunner;
    private final EnrichLookupService enrichLookupService;
    private final LookupFromIndexService lookupFromIndexService;
    private final ClusterService clusterService;
    private final AtomicLong childSessionIdGenerator = new AtomicLong();
    private final DataNodeComputeHandler dataNodeComputeHandler;
    private final ClusterComputeHandler clusterComputeHandler;
    private final ExchangeService exchangeService;

    public ComputeService(SearchService searchService, TransportService transportService, ExchangeService exchangeService, EnrichLookupService enrichLookupService, LookupFromIndexService lookupFromIndexService, ClusterService clusterService, ThreadPool threadPool, BigArrays bigArrays, BlockFactory blockFactory) {
        this.searchService = searchService;
        this.transportService = transportService;
        this.bigArrays = bigArrays.withCircuitBreaking();
        this.blockFactory = blockFactory;
        ExecutorService esqlExecutor = threadPool.executor("search");
        this.driverRunner = new DriverTaskRunner(transportService, (Executor)esqlExecutor);
        this.enrichLookupService = enrichLookupService;
        this.lookupFromIndexService = lookupFromIndexService;
        this.clusterService = clusterService;
        this.dataNodeComputeHandler = new DataNodeComputeHandler(this, searchService, transportService, exchangeService, esqlExecutor);
        this.clusterComputeHandler = new ClusterComputeHandler(this, exchangeService, transportService, esqlExecutor, this.dataNodeComputeHandler);
        this.exchangeService = exchangeService;
    }

    public void execute(String sessionId, CancellableTask rootTask, PhysicalPlan physicalPlan, Configuration configuration, FoldContext foldContext, EsqlExecutionInfo execInfo, ActionListener<Result> listener) {
        Tuple<PhysicalPlan, PhysicalPlan> coordinatorAndDataNodePlan = PlannerUtils.breakPlanBetweenCoordinatorAndDataNode(physicalPlan, configuration);
        List collectedPages = Collections.synchronizedList(new ArrayList());
        listener = listener.delegateResponse((l, e) -> {
            collectedPages.forEach(p -> Releasables.closeExpectNoException(() -> ((Page)p).releaseBlocks()));
            l.onFailure(e);
        });
        OutputExec coordinatorPlan = new OutputExec((PhysicalPlan)((Object)coordinatorAndDataNodePlan.v1()), collectedPages::add);
        PhysicalPlan dataNodePlan = (PhysicalPlan)((Object)coordinatorAndDataNodePlan.v2());
        if (dataNodePlan != null && !(dataNodePlan instanceof ExchangeSinkExec)) {
            assert (false) : "expected data node plan starts with an ExchangeSink; got " + String.valueOf((Object)dataNodePlan);
            listener.onFailure((Exception)new IllegalStateException("expected data node plan starts with an ExchangeSink; got " + String.valueOf((Object)dataNodePlan)));
            return;
        }
        Map clusterToConcreteIndices = this.transportService.getRemoteClusterService().groupIndices(SearchRequest.DEFAULT_INDICES_OPTIONS, (String[])PlannerUtils.planConcreteIndices(physicalPlan).toArray(String[]::new));
        QueryPragmas queryPragmas = configuration.pragmas();
        Runnable cancelQueryOnFailure = this.cancelQueryOnFailure(rootTask);
        if (dataNodePlan == null) {
            if (!clusterToConcreteIndices.values().stream().allMatch(v -> v.indices().length == 0)) {
                String error = "expected no concrete indices without data node plan; got " + String.valueOf(clusterToConcreteIndices);
                assert (false) : error;
                listener.onFailure((Exception)new IllegalStateException(error));
                return;
            }
            ComputeContext computeContext = new ComputeContext(this.newChildSession(sessionId), LOCAL_CLUSTER, List.of(), configuration, foldContext, null, null);
            ComputeService.updateShardCountForCoordinatorOnlyQuery(execInfo);
            try (ComputeListener computeListener = new ComputeListener(this.transportService.getThreadPool(), cancelQueryOnFailure, (ActionListener<List<DriverProfile>>)listener.map(profiles -> {
                ComputeService.updateExecutionInfoAfterCoordinatorOnlyQuery(execInfo);
                return new Result(physicalPlan.output(), collectedPages, (List<DriverProfile>)profiles, execInfo);
            }));){
                this.runCompute(rootTask, computeContext, coordinatorPlan, computeListener.acquireCompute());
                return;
            }
        }
        if (clusterToConcreteIndices.values().stream().allMatch(v -> v.indices().length == 0)) {
            String error = "expected concrete indices with data node plan but got empty; data node plan " + String.valueOf((Object)dataNodePlan);
            assert (false) : error;
            listener.onFailure((Exception)new IllegalStateException(error));
            return;
        }
        Map clusterToOriginalIndices = this.transportService.getRemoteClusterService().groupIndices(SearchRequest.DEFAULT_INDICES_OPTIONS, PlannerUtils.planOriginalIndices(physicalPlan));
        OriginalIndices localOriginalIndices = (OriginalIndices)clusterToOriginalIndices.remove(LOCAL_CLUSTER);
        OriginalIndices localConcreteIndices = (OriginalIndices)clusterToConcreteIndices.remove(LOCAL_CLUSTER);
        List<Attribute> outputAttributes = physicalPlan.output();
        ExchangeSourceHandler exchangeSource = new ExchangeSourceHandler(queryPragmas.exchangeBufferSize(), (Executor)this.transportService.getThreadPool().executor("search"));
        listener = ActionListener.runBefore((ActionListener)listener, () -> this.exchangeService.removeExchangeSourceHandler(sessionId));
        this.exchangeService.addExchangeSourceHandler(sessionId, exchangeSource);
        try (ComputeListener computeListener = new ComputeListener(this.transportService.getThreadPool(), cancelQueryOnFailure, (ActionListener<List<DriverProfile>>)listener.map(profiles -> {
            execInfo.markEndQuery();
            return new Result(outputAttributes, collectedPages, (List<DriverProfile>)profiles, execInfo);
        }));
             Releasable ignored = exchangeSource.addEmptySink();){
            AtomicBoolean localClusterWasInterrupted = new AtomicBoolean();
            try (ComputeListener localListener = new ComputeListener(this.transportService.getThreadPool(), cancelQueryOnFailure, (ActionListener<List<DriverProfile>>)computeListener.acquireCompute().delegateFailure((l, profiles) -> {
                if (execInfo.isCrossClusterSearch() && execInfo.clusterAliases().contains(LOCAL_CLUSTER)) {
                    TimeValue tookTime = TimeValue.timeValueNanos((long)(System.nanoTime() - execInfo.getRelativeStartNanos()));
                    EsqlExecutionInfo.Cluster.Status status = localClusterWasInterrupted.get() ? EsqlExecutionInfo.Cluster.Status.PARTIAL : EsqlExecutionInfo.Cluster.Status.SUCCESSFUL;
                    execInfo.swapCluster(LOCAL_CLUSTER, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setStatus(status).setTook(tookTime).build());
                }
                l.onResponse(profiles);
            }));){
                this.runCompute(rootTask, new ComputeContext(sessionId, LOCAL_CLUSTER, List.of(), configuration, foldContext, () -> ((ExchangeSourceHandler)exchangeSource).createExchangeSource(), null), coordinatorPlan, localListener.acquireCompute());
                if (localConcreteIndices != null && localConcreteIndices.indices().length > 0) {
                    this.dataNodeComputeHandler.startComputeOnDataNodes(sessionId, LOCAL_CLUSTER, rootTask, configuration, dataNodePlan, Set.of(localConcreteIndices.indices()), localOriginalIndices, exchangeSource, cancelQueryOnFailure, (ActionListener<ComputeResponse>)localListener.acquireCompute().map(r -> {
                        localClusterWasInterrupted.set(execInfo.isPartial());
                        if (execInfo.isCrossClusterSearch() && execInfo.clusterAliases().contains(LOCAL_CLUSTER)) {
                            execInfo.swapCluster(LOCAL_CLUSTER, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setTotalShards(r.getTotalShards()).setSuccessfulShards(r.getSuccessfulShards()).setSkippedShards(r.getSkippedShards()).setFailedShards(r.getFailedShards()).build());
                        }
                        return r.getProfiles();
                    }));
                }
            }
            List<ClusterComputeHandler.RemoteCluster> remoteClusters = this.clusterComputeHandler.getRemoteClusters(clusterToConcreteIndices, clusterToOriginalIndices);
            for (ClusterComputeHandler.RemoteCluster cluster : remoteClusters) {
                this.clusterComputeHandler.startComputeOnRemoteCluster(sessionId, rootTask, configuration, dataNodePlan, exchangeSource, cluster, cancelQueryOnFailure, (ActionListener<ComputeResponse>)computeListener.acquireCompute().map(r -> {
                    this.updateExecutionInfo(execInfo, cluster.clusterAlias(), (ComputeResponse)((Object)r));
                    return r.getProfiles();
                }));
            }
        }
    }

    private void updateExecutionInfo(EsqlExecutionInfo executionInfo, String clusterAlias, ComputeResponse resp) {
        Function<EsqlExecutionInfo.Cluster.Status, EsqlExecutionInfo.Cluster.Status> runningToSuccess = status -> {
            if (status == EsqlExecutionInfo.Cluster.Status.RUNNING) {
                return executionInfo.isPartial() ? EsqlExecutionInfo.Cluster.Status.PARTIAL : EsqlExecutionInfo.Cluster.Status.SUCCESSFUL;
            }
            return status;
        };
        if (resp.getTook() != null) {
            TimeValue tookTime = TimeValue.timeValueNanos((long)(executionInfo.planningTookTime().nanos() + resp.getTook().nanos()));
            executionInfo.swapCluster(clusterAlias, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setStatus((EsqlExecutionInfo.Cluster.Status)((Object)((Object)runningToSuccess.apply(v.getStatus())))).setTook(tookTime).setTotalShards(resp.getTotalShards()).setSuccessfulShards(resp.getSuccessfulShards()).setSkippedShards(resp.getSkippedShards()).setFailedShards(resp.getFailedShards()).build());
        } else {
            TimeValue tookTime = TimeValue.timeValueNanos((long)(System.nanoTime() - executionInfo.getRelativeStartNanos()));
            executionInfo.swapCluster(clusterAlias, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setStatus((EsqlExecutionInfo.Cluster.Status)((Object)((Object)runningToSuccess.apply(v.getStatus())))).setTook(tookTime).build());
        }
    }

    private static void updateShardCountForCoordinatorOnlyQuery(EsqlExecutionInfo execInfo) {
        if (execInfo.isCrossClusterSearch()) {
            for (String clusterAlias : execInfo.clusterAliases()) {
                execInfo.swapCluster(clusterAlias, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setTotalShards(0).setSuccessfulShards(0).setSkippedShards(0).setFailedShards(0).build());
            }
        }
    }

    private static void updateExecutionInfoAfterCoordinatorOnlyQuery(EsqlExecutionInfo execInfo) {
        execInfo.markEndQuery();
        if (execInfo.isCrossClusterSearch()) {
            assert (execInfo.planningTookTime() != null) : "Planning took time should be set on EsqlExecutionInfo but is null";
            for (String clusterAlias : execInfo.clusterAliases()) {
                execInfo.swapCluster(clusterAlias, (k, v) -> {
                    EsqlExecutionInfo.Cluster.Builder builder = new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setTook(execInfo.overallTook());
                    if (v.getStatus() == EsqlExecutionInfo.Cluster.Status.RUNNING) {
                        builder.setStatus(EsqlExecutionInfo.Cluster.Status.SUCCESSFUL);
                    }
                    return builder.build();
                });
            }
        }
    }

    void runCompute(CancellableTask task, ComputeContext context, PhysicalPlan plan, ActionListener<List<DriverProfile>> listener) {
        List<Driver> drivers;
        listener = ActionListener.runBefore(listener, () -> Releasables.close(context.searchContexts()));
        ArrayList<EsPhysicalOperationProviders.ShardContext> contexts = new ArrayList<EsPhysicalOperationProviders.ShardContext>(context.searchContexts().size());
        for (int i = 0; i < context.searchContexts().size(); ++i) {
            SearchContext searchContext = context.searchContexts().get(i);
            SearchExecutionContext searchExecutionContext = new SearchExecutionContext(searchContext.getSearchExecutionContext()){

                public SourceProvider createSourceProvider() {
                    Supplier<SourceProvider> supplier = () -> super.createSourceProvider();
                    return new ReinitializingSourceProvider(supplier);
                }
            };
            contexts.add(new EsPhysicalOperationProviders.DefaultShardContext(i, searchExecutionContext, searchContext.request().getAliasFilter()));
        }
        try {
            LocalExecutionPlanner planner = new LocalExecutionPlanner(context.sessionId(), context.clusterAlias(), task, this.bigArrays, this.blockFactory, this.clusterService.getSettings(), context.configuration(), context.exchangeSourceSupplier(), context.exchangeSinkSupplier(), this.enrichLookupService, this.lookupFromIndexService, new EsPhysicalOperationProviders(context.foldCtx(), contexts, this.searchService.getIndicesService().getAnalysis()), contexts);
            LOGGER.debug("Received physical plan:\n{}", new Object[]{plan});
            plan = PlannerUtils.localPlan(context.searchExecutionContexts(), context.configuration(), context.foldCtx(), plan);
            LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = planner.plan(context.foldCtx(), plan);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Local execution plan:\n{}", new Object[]{localExecutionPlan.describe()});
            }
            if ((drivers = localExecutionPlan.createDrivers(context.sessionId())).isEmpty()) {
                throw new IllegalStateException("no drivers created");
            }
            LOGGER.debug("using {} drivers", new Object[]{drivers.size()});
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        ActionListener listenerCollectingStatus = listener.map(ignored -> {
            if (context.configuration().profile()) {
                return drivers.stream().map(Driver::profile).toList();
            }
            return List.of();
        });
        listenerCollectingStatus = ActionListener.releaseAfter((ActionListener)listenerCollectingStatus, () -> Releasables.close((Iterable)drivers));
        this.driverRunner.executeDrivers((Task)task, drivers, (Executor)this.transportService.getThreadPool().executor("esql_worker"), listenerCollectingStatus);
    }

    static PhysicalPlan reductionPlan(ExchangeSinkExec plan, boolean enable) {
        PhysicalPlan p;
        PhysicalPlan reducePlan = new ExchangeSourceExec(plan.source(), plan.output(), plan.isIntermediateAgg());
        if (enable && (p = PlannerUtils.reductionPlan(plan)) != null) {
            reducePlan = (PhysicalPlan)p.replaceChildren(List.of(reducePlan));
        }
        return new ExchangeSinkExec(plan.source(), plan.output(), plan.isIntermediateAgg(), reducePlan);
    }

    String newChildSession(String session) {
        return session + "/" + this.childSessionIdGenerator.incrementAndGet();
    }

    Runnable cancelQueryOnFailure(CancellableTask task) {
        return new RunOnce(() -> {
            LOGGER.debug("cancelling ESQL task {} on failure", new Object[]{task});
            this.transportService.getTaskManager().cancelTaskAndDescendants(task, "cancelled on failure", false, ActionListener.noop());
        });
    }
}

