/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class FilterExec
extends UnaryExec {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "FilterExec", FilterExec::new);
    private final Expression condition;

    public FilterExec(Source source, PhysicalPlan child, Expression condition) {
        super(source, child);
        this.condition = condition;
    }

    private FilterExec(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteable((NamedWriteable)this.condition());
    }

    public String getWriteableName() {
        return FilterExec.ENTRY.name;
    }

    protected NodeInfo<FilterExec> info() {
        return NodeInfo.create((Node)this, FilterExec::new, (Object)((Object)this.child()), (Object)this.condition);
    }

    @Override
    public FilterExec replaceChild(PhysicalPlan newChild) {
        return new FilterExec(this.source(), newChild, this.condition);
    }

    public Expression condition() {
        return this.condition;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.condition, this.child()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FilterExec other = (FilterExec)((Object)obj);
        return Objects.equals(this.condition, other.condition) && Objects.equals((Object)this.child(), (Object)other.child());
    }
}

