/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.arithmetic.BinaryArithmeticOperation;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.ArithmeticOperation;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public abstract class EsqlArithmeticOperation
extends ArithmeticOperation
implements EvaluatorMapper {
    private final BinaryEvaluator ints;
    private final BinaryEvaluator longs;
    private final BinaryEvaluator ulongs;
    private final BinaryEvaluator doubles;
    private DataType dataType;

    EsqlArithmeticOperation(Source source, Expression left, Expression right, OperationSymbol op, BinaryEvaluator ints, BinaryEvaluator longs, BinaryEvaluator ulongs, BinaryEvaluator doubles) {
        super(source, left, right, op);
        this.ints = ints;
        this.longs = longs;
        this.ulongs = ulongs;
        this.doubles = doubles;
    }

    EsqlArithmeticOperation(StreamInput in, OperationSymbol op, BinaryEvaluator ints, BinaryEvaluator longs, BinaryEvaluator ulongs, BinaryEvaluator doubles) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), op, ints, longs, ulongs, doubles);
    }

    public Object fold(FoldContext ctx) {
        return EvaluatorMapper.super.fold(this.source(), ctx);
    }

    @Override
    public DataType dataType() {
        if (this.dataType == null) {
            this.dataType = EsqlDataTypeConverter.commonType(this.left().dataType(), this.right().dataType());
        }
        return this.dataType;
    }

    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution typeResolution = super.resolveType();
        if (typeResolution.unresolved()) {
            return typeResolution;
        }
        return this.checkCompatibility();
    }

    protected Expression.TypeResolution checkCompatibility() {
        DataType leftType = this.left().dataType();
        DataType rightType = this.right().dataType();
        if (rightType == DataType.UNSIGNED_LONG && !(leftType == DataType.UNSIGNED_LONG || leftType == DataType.NULL) || leftType == DataType.UNSIGNED_LONG && !(rightType == DataType.UNSIGNED_LONG || rightType == DataType.NULL)) {
            return new Expression.TypeResolution(EsqlArithmeticOperation.formatIncompatibleTypesMessage(this.symbol(), leftType, rightType));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public static String formatIncompatibleTypesMessage(String symbol, DataType leftType, DataType rightType) {
        return LoggerMessageFormat.format(null, (String)"[{}] has arguments with incompatible types [{}] and [{}]", (Object[])new Object[]{symbol, leftType.typeName(), rightType.typeName()});
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        DataType commonType = this.dataType();
        DataType leftType = this.left().dataType();
        if (leftType.isNumeric()) {
            BinaryEvaluator eval;
            EvalOperator.ExpressionEvaluator.Factory lhs = Cast.cast(this.source(), this.left().dataType(), commonType, toEvaluator.apply(this.left()));
            EvalOperator.ExpressionEvaluator.Factory rhs = Cast.cast(this.source(), this.right().dataType(), commonType, toEvaluator.apply(this.right()));
            if (commonType == DataType.INTEGER) {
                eval = this.ints;
            } else if (commonType == DataType.LONG) {
                eval = this.longs;
            } else if (commonType == DataType.UNSIGNED_LONG) {
                eval = this.ulongs;
            } else if (commonType == DataType.DOUBLE) {
                eval = this.doubles;
            } else {
                throw new EsqlIllegalArgumentException("Unsupported type " + String.valueOf(commonType));
            }
            return eval.apply(this.source(), lhs, rhs);
        }
        throw new EsqlIllegalArgumentException("Unsupported type " + String.valueOf(leftType));
    }

    @FunctionalInterface
    public static interface BinaryEvaluator {
        public EvalOperator.ExpressionEvaluator.Factory apply(Source var1, EvalOperator.ExpressionEvaluator.Factory var2, EvalOperator.ExpressionEvaluator.Factory var3);
    }

    static enum OperationSymbol implements BinaryArithmeticOperation
    {
        ADD("+"),
        SUB("-"),
        MUL("*"),
        DIV("/"),
        MOD("%");

        private final String symbol;

        private OperationSymbol(String symbol) {
            this.symbol = symbol;
        }

        public String getWriteableName() {
            throw new UnsupportedOperationException();
        }

        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Object doApply(Object o, Object o2) {
            throw new UnsupportedOperationException();
        }

        public String symbol() {
            return this.symbol;
        }
    }
}

