/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.logical;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.Negatable;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public class Not
extends UnaryScalarFunction
implements Negatable<Expression>,
TranslationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Not", Not::new);

    public Not(Source source, Expression child) {
        super(source, child);
    }

    private Not(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Not.ENTRY.name;
    }

    protected NodeInfo<Not> info() {
        return NodeInfo.create((Node)this, Not::new, (Object)this.field());
    }

    protected Not replaceChild(Expression newChild) {
        return new Not(this.source(), newChild);
    }

    protected Expression.TypeResolution resolveType() {
        if (DataType.BOOLEAN == this.field().dataType()) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return TypeResolutions.isBoolean((Expression)this.field(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public Object fold(FoldContext ctx) {
        return Not.apply(this.field().fold(ctx));
    }

    private static Boolean apply(Object input) {
        if (input == null) {
            return null;
        }
        if (!(input instanceof Boolean)) {
            throw new QlIllegalArgumentException("A boolean is required; received {}", new Object[]{input});
        }
        return (Boolean)input != false ? Boolean.FALSE : Boolean.TRUE;
    }

    protected Expression canonicalize() {
        if (this.field() instanceof Negatable) {
            return ((Negatable)this.field()).negate().canonical();
        }
        return super.canonicalize();
    }

    public Expression negate() {
        return this.field();
    }

    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    static Expression negate(Expression exp) {
        return exp instanceof Negatable ? ((Negatable)exp).negate() : new Not(exp.source(), exp);
    }

    @Override
    public boolean translatable(LucenePushdownPredicates pushdownPredicates) {
        TranslationAware aware;
        Expression expression = this.field();
        return expression instanceof TranslationAware && (aware = (TranslationAware)expression).translatable(pushdownPredicates);
    }

    @Override
    public Query asQuery(TranslatorHandler handler) {
        return handler.asQuery(this.field()).negate(this.source());
    }
}

