/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.AbstractHashFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Hash;

public class Md5
extends AbstractHashFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MD5", Md5::new);
    private static final Hash.HashFunction MD5 = Hash.HashFunction.create("MD5");

    @FunctionInfo(returnType={"keyword"}, description="Computes the MD5 hash of the input.", examples={@Example(file="hash", tag="md5")})
    public Md5(Source source, @Param(name="input", type={"keyword", "text"}, description="Input to hash.") Expression input) {
        super(source, input);
    }

    private Md5(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected Hash.HashFunction getHashFunction() {
        return MD5;
    }

    public String getWriteableName() {
        return Md5.ENTRY.name;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Md5(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Md5::new, (Object)this.field);
    }
}

