/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSum;

public final class MvSumDoubleEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    public MvSumDoubleEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
    }

    @Override
    public String name() {
        return "MvSum";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        DoubleBlock v = (DoubleBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            CompensatedSum work = new CompensatedSum();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                for (int i = first; i < end; ++i) {
                    double value = v.getDouble(i);
                    MvSum.process(work, value);
                }
                double result = MvSum.finish(work);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        DoubleBlock v = (DoubleBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleVector.FixedBuilder builder = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            CompensatedSum work = new CompensatedSum();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                for (int i = first; i < end; ++i) {
                    double value = v.getDouble(i);
                    MvSum.process(work, value);
                }
                double result = MvSum.finish(work);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build().asBlock();
            return doubleBlock;
        }
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvSumDoubleEvaluator get(DriverContext context) {
            return new MvSumDoubleEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvSum[field=" + String.valueOf(this.field) + "]";
        }
    }
}

