/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateParse;

public final class DateParseEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator val;
    private final EvalOperator.ExpressionEvaluator formatter;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DateParseEvaluator(Source source, EvalOperator.ExpressionEvaluator val, EvalOperator.ExpressionEvaluator formatter, DriverContext driverContext) {
        this.source = source;
        this.val = val;
        this.formatter = formatter;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock valBlock = (BytesRefBlock)this.val.eval(page);){
            LongBlock longBlock;
            block20: {
                BytesRefVector formatterVector;
                BytesRefVector valVector;
                BytesRefBlock formatterBlock;
                block18: {
                    LongBlock longBlock2;
                    block19: {
                        block16: {
                            LongBlock longBlock3;
                            block17: {
                                formatterBlock = (BytesRefBlock)this.formatter.eval(page);
                                try {
                                    valVector = valBlock.asVector();
                                    if (valVector != null) break block16;
                                    longBlock3 = this.eval(page.getPositionCount(), valBlock, formatterBlock);
                                    if (formatterBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (formatterBlock != null) {
                                        try {
                                            formatterBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                formatterBlock.close();
                            }
                            return longBlock3;
                        }
                        formatterVector = formatterBlock.asVector();
                        if (formatterVector != null) break block18;
                        longBlock2 = this.eval(page.getPositionCount(), valBlock, formatterBlock);
                        if (formatterBlock == null) break block19;
                        formatterBlock.close();
                    }
                    return longBlock2;
                }
                longBlock = this.eval(page.getPositionCount(), valVector, formatterVector);
                if (formatterBlock == null) break block20;
                formatterBlock.close();
            }
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, BytesRefBlock valBlock, BytesRefBlock formatterBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            BytesRef valScratch = new BytesRef();
            BytesRef formatterScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valBlock.getValueCount(p) != 1) {
                    if (valBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (formatterBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (formatterBlock.getValueCount(p) != 1) {
                    if (formatterBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendLong(DateParse.process(valBlock.getBytesRef(valBlock.getFirstValueIndex(p), valScratch), formatterBlock.getBytesRef(formatterBlock.getFirstValueIndex(p), formatterScratch)));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, BytesRefVector valVector, BytesRefVector formatterVector) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            BytesRef valScratch = new BytesRef();
            BytesRef formatterScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendLong(DateParse.process(valVector.getBytesRef(p, valScratch), formatterVector.getBytesRef(p, formatterScratch)));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "DateParseEvaluator[val=" + String.valueOf(this.val) + ", formatter=" + String.valueOf(this.formatter) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.val, this.formatter});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory val;
        private final EvalOperator.ExpressionEvaluator.Factory formatter;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory val, EvalOperator.ExpressionEvaluator.Factory formatter) {
            this.source = source;
            this.val = val;
            this.formatter = formatter;
        }

        public DateParseEvaluator get(DriverContext context) {
            return new DateParseEvaluator(this.source, this.val.get(context), this.formatter.get(context), context);
        }

        public String toString() {
            return "DateParseEvaluator[val=" + String.valueOf(this.val) + ", formatter=" + String.valueOf(this.formatter) + "]";
        }
    }
}

