/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDouble;

public final class ToDoubleFromStringEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    public ToDoubleFromStringEvaluator(EvalOperator.ExpressionEvaluator field, Source source, DriverContext driverContext) {
        super(driverContext, field, source);
    }

    @Override
    public String name() {
        return "ToDoubleFromString";
    }

    @Override
    public Block evalVector(Vector v) {
        BytesRefVector vector = (BytesRefVector)v;
        int positionCount = v.getPositionCount();
        BytesRef scratchPad = new BytesRef();
        if (vector.isConstant()) {
            try {
                return this.driverContext.blockFactory().newConstantDoubleBlockWith(ToDoubleFromStringEvaluator.evalValue(vector, 0, scratchPad), positionCount);
            }
            catch (InvalidArgumentException e) {
                this.registerException((Exception)((Object)e));
                return this.driverContext.blockFactory().newConstantNullBlock(positionCount);
            }
        }
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    builder.appendDouble(ToDoubleFromStringEvaluator.evalValue(vector, p, scratchPad));
                    continue;
                }
                catch (InvalidArgumentException e) {
                    this.registerException((Exception)((Object)e));
                    builder.appendNull();
                }
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private static double evalValue(BytesRefVector container, int index, BytesRef scratchPad) {
        BytesRef value = container.getBytesRef(index, scratchPad);
        return ToDouble.fromKeyword(value);
    }

    @Override
    public Block evalBlock(Block b) {
        BytesRefBlock block = (BytesRefBlock)b;
        int positionCount = block.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            BytesRef scratchPad = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    try {
                        double value = ToDoubleFromStringEvaluator.evalValue(block, i, scratchPad);
                        if (!positionOpened && valueCount > 1) {
                            builder.beginPositionEntry();
                            positionOpened = true;
                        }
                        builder.appendDouble(value);
                        valuesAppended = true;
                        continue;
                    }
                    catch (InvalidArgumentException e) {
                        this.registerException((Exception)((Object)e));
                    }
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private static double evalValue(BytesRefBlock container, int index, BytesRef scratchPad) {
        BytesRef value = container.getBytesRef(index, scratchPad);
        return ToDouble.fromKeyword(value);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field, Source source) {
            this.field = field;
            this.source = source;
        }

        public ToDoubleFromStringEvaluator get(DriverContext context) {
            return new ToDoubleFromStringEvaluator(this.field.get(context), this.source, context);
        }

        public String toString() {
            return "ToDoubleFromStringEvaluator[field=" + String.valueOf(this.field) + "]";
        }
    }
}

