/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBoolean;

public final class ToBooleanFromDoubleEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    public ToBooleanFromDoubleEvaluator(EvalOperator.ExpressionEvaluator field, Source source, DriverContext driverContext) {
        super(driverContext, field, source);
    }

    @Override
    public String name() {
        return "ToBooleanFromDouble";
    }

    @Override
    public Block evalVector(Vector v) {
        DoubleVector vector = (DoubleVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantBooleanBlockWith(ToBooleanFromDoubleEvaluator.evalValue(vector, 0), positionCount);
        }
        try (BooleanBlock.Builder builder = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendBoolean(ToBooleanFromDoubleEvaluator.evalValue(vector, p));
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    private static boolean evalValue(DoubleVector container, int index) {
        double value = container.getDouble(index);
        return ToBoolean.fromDouble(value);
    }

    @Override
    public Block evalBlock(Block b) {
        DoubleBlock block = (DoubleBlock)b;
        int positionCount = block.getPositionCount();
        try (BooleanBlock.Builder builder = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    boolean value = ToBooleanFromDoubleEvaluator.evalValue(block, i);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendBoolean(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    private static boolean evalValue(DoubleBlock container, int index) {
        double value = container.getDouble(index);
        return ToBoolean.fromDouble(value);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field, Source source) {
            this.field = field;
            this.source = source;
        }

        public ToBooleanFromDoubleEvaluator get(DriverContext context) {
            return new ToBooleanFromDoubleEvaluator(this.field.get(context), this.source, context);
        }

        public String toString() {
            return "ToBooleanFromDoubleEvaluator[field=" + String.valueOf(this.field) + "]";
        }
    }
}

