/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.transform.transforms.DestAlias;
import org.elasticsearch.xpack.core.transform.transforms.NullRetentionPolicyConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.transform.utils.SecondaryAuthorizationUtils;

final class TransformPrivilegeChecker {
    static void checkPrivileges(String operationName, Settings settings, SecurityContext securityContext, IndexNameExpressionResolver indexNameExpressionResolver, ClusterState clusterState, Client client, TransformConfig config, boolean checkDestIndexPrivileges, ActionListener<Void> listener) {
        assert (((Boolean)XPackSettings.SECURITY_ENABLED.get(settings)).booleanValue());
        SecondaryAuthorizationUtils.useSecondaryAuthIfAvailable(securityContext, () -> {
            String username = securityContext.getUser().principal();
            ActionListener hasPrivilegesResponseListener = ActionListener.wrap(response -> TransformPrivilegeChecker.handlePrivilegesResponse(operationName, username, config.getId(), response, listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            HasPrivilegesRequest hasPrivilegesRequest = TransformPrivilegeChecker.buildPrivilegesRequest(config, indexNameExpressionResolver, clusterState, username, checkDestIndexPrivileges);
            if (hasPrivilegesRequest.indexPrivileges().length == 0) {
                listener.onResponse(null);
            } else {
                client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)hasPrivilegesRequest, hasPrivilegesResponseListener);
            }
        });
    }

    private static HasPrivilegesRequest buildPrivilegesRequest(TransformConfig config, IndexNameExpressionResolver indexNameExpressionResolver, ClusterState clusterState, String username, boolean checkDestIndexPrivileges) {
        ArrayList<RoleDescriptor.IndicesPrivileges> indicesPrivileges = new ArrayList<RoleDescriptor.IndicesPrivileges>(2);
        String[] sourceIndex = (String[])Arrays.stream(config.getSource().getIndex()).filter(Predicate.not(RemoteClusterLicenseChecker::isRemoteIndex)).toArray(String[]::new);
        if (sourceIndex.length > 0) {
            RoleDescriptor.IndicesPrivileges sourceIndexPrivileges = RoleDescriptor.IndicesPrivileges.builder().indices(sourceIndex).privileges(new String[]{"read", "view_index_metadata"}).allowRestrictedIndices(true).build();
            indicesPrivileges.add(sourceIndexPrivileges);
        }
        if (checkDestIndexPrivileges) {
            String destIndex = config.getDestination().getIndex();
            String[] concreteDest = indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{destIndex});
            ArrayList<String> destPrivileges = new ArrayList<String>(4);
            destPrivileges.add("read");
            destPrivileges.add("index");
            if (concreteDest.length == 0) {
                destPrivileges.add("create_index");
            }
            if (config.getRetentionPolicyConfig() != null && !(config.getRetentionPolicyConfig() instanceof NullRetentionPolicyConfig)) {
                destPrivileges.add("delete");
            }
            if (config.getDestination().getAliases() != null && !config.getDestination().getAliases().isEmpty()) {
                destPrivileges.add("manage");
                RoleDescriptor.IndicesPrivileges destAliasPrivileges = RoleDescriptor.IndicesPrivileges.builder().indices(config.getDestination().getAliases().stream().map(DestAlias::getAlias).toList()).privileges(new String[]{"manage"}).allowRestrictedIndices(true).build();
                indicesPrivileges.add(destAliasPrivileges);
            }
            RoleDescriptor.IndicesPrivileges destIndexPrivileges = RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{destIndex}).privileges(destPrivileges).allowRestrictedIndices(true).build();
            indicesPrivileges.add(destIndexPrivileges);
        }
        HasPrivilegesRequest privRequest = new HasPrivilegesRequest();
        privRequest.username(username);
        privRequest.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
        privRequest.clusterPrivileges(Strings.EMPTY_ARRAY);
        privRequest.indexPrivileges((RoleDescriptor.IndicesPrivileges[])indicesPrivileges.toArray(RoleDescriptor.IndicesPrivileges[]::new));
        return privRequest;
    }

    private static void handlePrivilegesResponse(String operationName, String username, String transformId, HasPrivilegesResponse privilegesResponse, ActionListener<Void> listener) {
        if (privilegesResponse.isCompleteMatch()) {
            listener.onResponse(null);
        } else {
            List missingPrivileges = privilegesResponse.getIndexPrivileges().stream().map(indexPrivileges -> indexPrivileges.getPrivileges().entrySet().stream().filter(e -> !Boolean.TRUE.equals(e.getValue())).map(Map.Entry::getKey).collect(Collectors.joining(", ", indexPrivileges.getResource() + ":[", "]"))).collect(Collectors.toList());
            listener.onFailure((Exception)Exceptions.authorizationError((String)"Cannot {} transform [{}] because user {} lacks the required permissions {}", (Object[])new Object[]{operationName, transformId, username, missingPrivileges}));
        }
    }

    private TransformPrivilegeChecker() {
    }
}

