/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.application.connector.action.ConnectorCreateActionResponse;
import org.elasticsearch.xpack.application.connector.action.PutConnectorAction;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutConnectorAction
extends BaseRestHandler {
    private static final String CONNECTOR_ID_PARAM = "connector_id";

    public String getName() {
        return "connector_put_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_connector/{connector_id}"), new RestHandler.Route(RestRequest.Method.PUT, "/_connector"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String connectorId = restRequest.param(CONNECTOR_ID_PARAM);
        PutConnectorAction.Request request = restRequest.hasContent() ? PutConnectorAction.Request.fromXContent(restRequest.contentParser(), connectorId) : new PutConnectorAction.Request(connectorId);
        return channel -> client.execute(PutConnectorAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel, ConnectorCreateActionResponse::status, r -> null));
    }
}

