/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.application.connector.ConnectorSyncStatus;

public class ConnectorSyncInfo
implements Writeable,
ToXContentFragment {
    @Nullable
    private final String lastAccessControlSyncError;
    @Nullable
    private final Instant lastAccessControlSyncScheduledAt;
    @Nullable
    private final ConnectorSyncStatus lastAccessControlSyncStatus;
    @Nullable
    private final Long lastDeletedDocumentCount;
    @Nullable
    private final Instant lastIncrementalSyncScheduledAt;
    @Nullable
    private final Long lastIndexedDocumentCount;
    @Nullable
    private final String lastSyncError;
    @Nullable
    private final Instant lastSyncScheduledAt;
    @Nullable
    private final ConnectorSyncStatus lastSyncStatus;
    @Nullable
    private final Instant lastSynced;
    public static final ParseField LAST_ACCESS_CONTROL_SYNC_ERROR = new ParseField("last_access_control_sync_error", new String[0]);
    public static final ParseField LAST_ACCESS_CONTROL_SYNC_STATUS_FIELD = new ParseField("last_access_control_sync_status", new String[0]);
    public static final ParseField LAST_ACCESS_CONTROL_SYNC_SCHEDULED_AT_FIELD = new ParseField("last_access_control_sync_scheduled_at", new String[0]);
    public static final ParseField LAST_DELETED_DOCUMENT_COUNT_FIELD = new ParseField("last_deleted_document_count", new String[0]);
    public static final ParseField LAST_INCREMENTAL_SYNC_SCHEDULED_AT_FIELD = new ParseField("last_incremental_sync_scheduled_at", new String[0]);
    public static final ParseField LAST_INDEXED_DOCUMENT_COUNT_FIELD = new ParseField("last_indexed_document_count", new String[0]);
    public static final ParseField LAST_SYNC_ERROR_FIELD = new ParseField("last_sync_error", new String[0]);
    public static final ParseField LAST_SYNC_SCHEDULED_AT_FIELD = new ParseField("last_sync_scheduled_at", new String[0]);
    public static final ParseField LAST_SYNC_STATUS_FIELD = new ParseField("last_sync_status", new String[0]);
    public static final ParseField LAST_SYNCED_FIELD = new ParseField("last_synced", new String[0]);

    private ConnectorSyncInfo(String lastAccessControlSyncError, Instant lastAccessControlSyncScheduledAt, ConnectorSyncStatus lastAccessControlSyncStatus, Long lastDeletedDocumentCount, Instant lastIncrementalSyncScheduledAt, Long lastIndexedDocumentCount, String lastSyncError, Instant lastSyncScheduledAt, ConnectorSyncStatus lastSyncStatus, Instant lastSynced) {
        this.lastAccessControlSyncError = lastAccessControlSyncError;
        this.lastAccessControlSyncScheduledAt = lastAccessControlSyncScheduledAt;
        this.lastAccessControlSyncStatus = lastAccessControlSyncStatus;
        this.lastDeletedDocumentCount = lastDeletedDocumentCount;
        this.lastIncrementalSyncScheduledAt = lastIncrementalSyncScheduledAt;
        this.lastIndexedDocumentCount = lastIndexedDocumentCount;
        this.lastSyncError = lastSyncError;
        this.lastSyncScheduledAt = lastSyncScheduledAt;
        this.lastSyncStatus = lastSyncStatus;
        this.lastSynced = lastSynced;
    }

    public ConnectorSyncInfo(StreamInput in) throws IOException {
        this.lastAccessControlSyncError = in.readOptionalString();
        this.lastAccessControlSyncScheduledAt = in.readOptionalInstant();
        this.lastAccessControlSyncStatus = (ConnectorSyncStatus)in.readOptionalEnum(ConnectorSyncStatus.class);
        this.lastDeletedDocumentCount = in.readOptionalLong();
        this.lastIncrementalSyncScheduledAt = in.readOptionalInstant();
        this.lastIndexedDocumentCount = in.readOptionalLong();
        this.lastSyncError = in.readOptionalString();
        this.lastSyncScheduledAt = in.readOptionalInstant();
        this.lastSyncStatus = (ConnectorSyncStatus)in.readOptionalEnum(ConnectorSyncStatus.class);
        this.lastSynced = in.readOptionalInstant();
    }

    public String getLastAccessControlSyncError() {
        return this.lastAccessControlSyncError;
    }

    public Instant getLastAccessControlSyncScheduledAt() {
        return this.lastAccessControlSyncScheduledAt;
    }

    public ConnectorSyncStatus getLastAccessControlSyncStatus() {
        return this.lastAccessControlSyncStatus;
    }

    public Long getLastDeletedDocumentCount() {
        return this.lastDeletedDocumentCount;
    }

    public Instant getLastIncrementalSyncScheduledAt() {
        return this.lastIncrementalSyncScheduledAt;
    }

    public Long getLastIndexedDocumentCount() {
        return this.lastIndexedDocumentCount;
    }

    public String getLastSyncError() {
        return this.lastSyncError;
    }

    public Instant getLastSyncScheduledAt() {
        return this.lastSyncScheduledAt;
    }

    public ConnectorSyncStatus getLastSyncStatus() {
        return this.lastSyncStatus;
    }

    public Instant getLastSynced() {
        return this.lastSynced;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.lastAccessControlSyncError != null) {
            builder.field(LAST_ACCESS_CONTROL_SYNC_ERROR.getPreferredName(), this.lastAccessControlSyncError);
        }
        if (this.lastAccessControlSyncStatus != null) {
            builder.field(LAST_ACCESS_CONTROL_SYNC_STATUS_FIELD.getPreferredName(), (Enum)this.lastAccessControlSyncStatus);
        }
        if (this.lastAccessControlSyncScheduledAt != null) {
            builder.field(LAST_ACCESS_CONTROL_SYNC_SCHEDULED_AT_FIELD.getPreferredName(), (Object)this.lastAccessControlSyncScheduledAt);
        }
        if (this.lastDeletedDocumentCount != null) {
            builder.field(LAST_DELETED_DOCUMENT_COUNT_FIELD.getPreferredName(), this.lastDeletedDocumentCount);
        }
        if (this.lastIncrementalSyncScheduledAt != null) {
            builder.field(LAST_INCREMENTAL_SYNC_SCHEDULED_AT_FIELD.getPreferredName(), (Object)this.lastIncrementalSyncScheduledAt);
        }
        if (this.lastIndexedDocumentCount != null) {
            builder.field(LAST_INDEXED_DOCUMENT_COUNT_FIELD.getPreferredName(), this.lastIndexedDocumentCount);
        }
        if (this.lastSyncError != null) {
            builder.field(LAST_SYNC_ERROR_FIELD.getPreferredName(), this.lastSyncError);
        }
        if (this.lastSyncScheduledAt != null) {
            builder.field(LAST_SYNC_SCHEDULED_AT_FIELD.getPreferredName(), (Object)this.lastSyncScheduledAt);
        }
        if (this.lastSyncStatus != null) {
            builder.field(LAST_SYNC_STATUS_FIELD.getPreferredName(), (Enum)this.lastSyncStatus);
        }
        if (this.lastSynced != null) {
            builder.field(LAST_SYNCED_FIELD.getPreferredName(), (Object)this.lastSynced);
        }
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.lastAccessControlSyncError);
        out.writeOptionalInstant(this.lastAccessControlSyncScheduledAt);
        out.writeOptionalEnum((Enum)this.lastAccessControlSyncStatus);
        out.writeOptionalLong(this.lastDeletedDocumentCount);
        out.writeOptionalInstant(this.lastIncrementalSyncScheduledAt);
        out.writeOptionalLong(this.lastIndexedDocumentCount);
        out.writeOptionalString(this.lastSyncError);
        out.writeOptionalInstant(this.lastSyncScheduledAt);
        out.writeOptionalEnum((Enum)this.lastSyncStatus);
        out.writeOptionalInstant(this.lastSynced);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorSyncInfo that = (ConnectorSyncInfo)o;
        return Objects.equals(this.lastAccessControlSyncError, that.lastAccessControlSyncError) && Objects.equals(this.lastAccessControlSyncScheduledAt, that.lastAccessControlSyncScheduledAt) && this.lastAccessControlSyncStatus == that.lastAccessControlSyncStatus && Objects.equals(this.lastDeletedDocumentCount, that.lastDeletedDocumentCount) && Objects.equals(this.lastIncrementalSyncScheduledAt, that.lastIncrementalSyncScheduledAt) && Objects.equals(this.lastIndexedDocumentCount, that.lastIndexedDocumentCount) && Objects.equals(this.lastSyncError, that.lastSyncError) && Objects.equals(this.lastSyncScheduledAt, that.lastSyncScheduledAt) && this.lastSyncStatus == that.lastSyncStatus && Objects.equals(this.lastSynced, that.lastSynced);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lastAccessControlSyncError, this.lastAccessControlSyncScheduledAt, this.lastAccessControlSyncStatus, this.lastDeletedDocumentCount, this.lastIncrementalSyncScheduledAt, this.lastIndexedDocumentCount, this.lastSyncError, this.lastSyncScheduledAt, this.lastSyncStatus, this.lastSynced});
    }

    public static class Builder {
        private String lastAccessControlSyncError;
        private Instant lastAccessControlSyncScheduledAt;
        private ConnectorSyncStatus lastAccessControlSyncStatus;
        private Long lastDeletedDocumentCount;
        private Instant lastIncrementalSyncScheduledAt;
        private Long lastIndexedDocumentCount;
        private String lastSyncError;
        private Instant lastSyncScheduledAt;
        private ConnectorSyncStatus lastSyncStatus;
        private Instant lastSynced;

        public Builder setLastAccessControlSyncError(String lastAccessControlSyncError) {
            this.lastAccessControlSyncError = lastAccessControlSyncError;
            return this;
        }

        public Builder setLastAccessControlSyncScheduledAt(Instant lastAccessControlSyncScheduledAt) {
            this.lastAccessControlSyncScheduledAt = lastAccessControlSyncScheduledAt;
            return this;
        }

        public Builder setLastAccessControlSyncStatus(ConnectorSyncStatus lastAccessControlSyncStatus) {
            this.lastAccessControlSyncStatus = lastAccessControlSyncStatus;
            return this;
        }

        public Builder setLastDeletedDocumentCount(Long lastDeletedDocumentCount) {
            this.lastDeletedDocumentCount = lastDeletedDocumentCount;
            return this;
        }

        public Builder setLastIncrementalSyncScheduledAt(Instant lastIncrementalSyncScheduledAt) {
            this.lastIncrementalSyncScheduledAt = lastIncrementalSyncScheduledAt;
            return this;
        }

        public Builder setLastIndexedDocumentCount(Long lastIndexedDocumentCount) {
            this.lastIndexedDocumentCount = lastIndexedDocumentCount;
            return this;
        }

        public Builder setLastSyncError(String lastSyncError) {
            this.lastSyncError = lastSyncError;
            return this;
        }

        public Builder setLastSyncScheduledAt(Instant lastSyncScheduledAt) {
            this.lastSyncScheduledAt = lastSyncScheduledAt;
            return this;
        }

        public Builder setLastSyncStatus(ConnectorSyncStatus lastSyncStatus) {
            this.lastSyncStatus = lastSyncStatus;
            return this;
        }

        public Builder setLastSynced(Instant lastSynced) {
            this.lastSynced = lastSynced;
            return this;
        }

        public ConnectorSyncInfo build() {
            return new ConnectorSyncInfo(this.lastAccessControlSyncError, this.lastAccessControlSyncScheduledAt, this.lastAccessControlSyncStatus, this.lastDeletedDocumentCount, this.lastIncrementalSyncScheduledAt, this.lastIndexedDocumentCount, this.lastSyncError, this.lastSyncScheduledAt, this.lastSyncStatus, this.lastSynced);
        }
    }
}

