/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.filtering.FilteringAdvancedSnippet;
import org.elasticsearch.xpack.application.connector.filtering.FilteringPolicy;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRule;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRuleCondition;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRules;
import org.elasticsearch.xpack.application.connector.filtering.FilteringValidationInfo;
import org.elasticsearch.xpack.application.connector.filtering.FilteringValidationState;

public class ConnectorFiltering
implements Writeable,
ToXContentObject {
    private FilteringRules active;
    private final String domain = "DEFAULT";
    private FilteringRules draft;
    private static final ParseField ACTIVE_FIELD = new ParseField("active", new String[0]);
    private static final ParseField DRAFT_FIELD = new ParseField("draft", new String[0]);
    private static final ConstructingObjectParser<ConnectorFiltering, Void> PARSER = new ConstructingObjectParser("connector_filtering", true, args -> new Builder().setActive((FilteringRules)args[0]).setDraft((FilteringRules)args[1]).build());
    private static final ConstructingObjectParser<List<ConnectorFiltering>, Void> CONNECTOR_FILTERING_PARSER;

    public ConnectorFiltering(FilteringRules active, FilteringRules draft) {
        this.active = active;
        this.draft = draft;
    }

    public ConnectorFiltering(StreamInput in) throws IOException {
        this.active = new FilteringRules(in);
        this.draft = new FilteringRules(in);
    }

    public FilteringRules getActive() {
        return this.active;
    }

    public String getDomain() {
        return "DEFAULT";
    }

    public FilteringRules getDraft() {
        return this.draft;
    }

    public ConnectorFiltering setActive(FilteringRules active) {
        this.active = active;
        return this;
    }

    public ConnectorFiltering setDraft(FilteringRules draft) {
        this.draft = draft;
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACTIVE_FIELD.getPreferredName(), (ToXContent)this.active);
        builder.field("domain", "DEFAULT");
        builder.field(DRAFT_FIELD.getPreferredName(), (ToXContent)this.draft);
        builder.endObject();
        return builder;
    }

    public static ConnectorFiltering fromXContent(XContentParser parser) throws IOException {
        return (ConnectorFiltering)PARSER.parse(parser, null);
    }

    public static ConnectorFiltering fromXContentBytes(BytesReference source, XContentType xContentType) {
        ConnectorFiltering connectorFiltering;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                connectorFiltering = ConnectorFiltering.fromXContent(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse a connector filtering.", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return connectorFiltering;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.active.writeTo(out);
        this.draft.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorFiltering that = (ConnectorFiltering)o;
        return Objects.equals(this.active, that.active) && Objects.equals("DEFAULT", that.domain) && Objects.equals(this.draft, that.draft);
    }

    public int hashCode() {
        return Objects.hash(this.active, "DEFAULT", this.draft);
    }

    public static List<ConnectorFiltering> fromXContentBytesConnectorFiltering(BytesReference source, XContentType xContentType) {
        List list;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                list = (List)CONNECTOR_FILTERING_PARSER.parse(parser, null);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse a connector filtering.", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return list;
    }

    public static FilteringRule getDefaultFilteringRule(Instant timestamp, Integer order) {
        return new FilteringRule.Builder().setCreatedAt(timestamp).setField("_").setId("DEFAULT").setOrder(order).setPolicy(FilteringPolicy.INCLUDE).setRule(FilteringRuleCondition.REGEX).setUpdatedAt(timestamp).setValue(".*").build();
    }

    public static FilteringRule getDefaultFilteringRuleWithOrder(Integer order) {
        return ConnectorFiltering.getDefaultFilteringRule(null, order);
    }

    public static boolean isDefaultFilteringRule(FilteringRule rule) {
        return rule.equalsExceptForTimestampsAndOrder(ConnectorFiltering.getDefaultFilteringRuleWithOrder(0));
    }

    public static List<FilteringRule> sortFilteringRulesByOrder(List<FilteringRule> rules) {
        if (rules.isEmpty()) {
            return List.of(ConnectorFiltering.getDefaultFilteringRuleWithOrder(0));
        }
        Optional<FilteringRule> defaultRuleTimeStamp = rules.stream().filter(ConnectorFiltering::isDefaultFilteringRule).findFirst();
        List<FilteringRule> sortedRules = rules.stream().filter(rule -> !ConnectorFiltering.isDefaultFilteringRule(rule)).sorted(Comparator.comparingInt(FilteringRule::getOrder)).collect(Collectors.toList());
        sortedRules.add(ConnectorFiltering.getDefaultFilteringRule(defaultRuleTimeStamp.map(FilteringRule::getCreatedAt).orElse(null), sortedRules.isEmpty() ? 0 : ((FilteringRule)sortedRules.get(sortedRules.size() - 1)).getOrder() + 1));
        return sortedRules;
    }

    public static ConnectorFiltering getDefaultConnectorFilteringConfig() {
        Instant currentTimestamp = Instant.now();
        return new Builder().setActive(new FilteringRules.Builder().setAdvancedSnippet(new FilteringAdvancedSnippet.Builder().setAdvancedSnippetCreatedAt(currentTimestamp).setAdvancedSnippetUpdatedAt(currentTimestamp).setAdvancedSnippetValue(Collections.emptyMap()).build()).setRules(List.of(ConnectorFiltering.getDefaultFilteringRule(currentTimestamp, 0))).setFilteringValidationInfo(new FilteringValidationInfo.Builder().setValidationErrors(Collections.emptyList()).setValidationState(FilteringValidationState.VALID).build()).build()).setDraft(new FilteringRules.Builder().setAdvancedSnippet(new FilteringAdvancedSnippet.Builder().setAdvancedSnippetCreatedAt(currentTimestamp).setAdvancedSnippetUpdatedAt(currentTimestamp).setAdvancedSnippetValue(Collections.emptyMap()).build()).setRules(List.of(ConnectorFiltering.getDefaultFilteringRule(currentTimestamp, 0))).setFilteringValidationInfo(new FilteringValidationInfo.Builder().setValidationErrors(Collections.emptyList()).setValidationState(FilteringValidationState.VALID).build()).build()).build();
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> FilteringRules.fromXContent(p), ACTIVE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> FilteringRules.fromXContent(p), DRAFT_FIELD);
        CONNECTOR_FILTERING_PARSER = new ConstructingObjectParser("connector_filtering_parser", true, args -> (List)args[0]);
        CONNECTOR_FILTERING_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> ConnectorFiltering.fromXContent(p), Connector.FILTERING_FIELD);
    }

    public static class Builder {
        private FilteringRules active;
        private FilteringRules draft;

        public Builder setActive(FilteringRules active) {
            this.active = active;
            return this;
        }

        public Builder setDraft(FilteringRules draft) {
            this.draft = draft;
            return this;
        }

        public ConnectorFiltering build() {
            return new ConnectorFiltering(this.active, this.draft);
        }
    }
}

