/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application;

import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.utils.LicenseUtils;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureTransportAction;

public class EnterpriseSearchInfoTransportAction
extends XPackInfoFeatureTransportAction {
    private final boolean enabled;
    private final XPackLicenseState licenseState;

    @Inject
    public EnterpriseSearchInfoTransportAction(TransportService transportService, ActionFilters actionFilters, Settings settings, XPackLicenseState licenseState) {
        super(XPackInfoFeatureAction.ENTERPRISE_SEARCH.name(), transportService, actionFilters);
        this.enabled = (Boolean)XPackSettings.ENTERPRISE_SEARCH_ENABLED.get(settings);
        this.licenseState = licenseState;
    }

    public String name() {
        return "enterprise_search";
    }

    public boolean available() {
        return LicenseUtils.PLATINUM_LICENSED_FEATURE.checkWithoutTracking(this.licenseState);
    }

    public boolean enabled() {
        return this.enabled;
    }
}

