/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.vectors.QueryProfilerProvider;

public class ESKnnFloatVectorQuery
extends KnnFloatVectorQuery
implements QueryProfilerProvider {
    private final Integer kParam;
    private long vectorOpsCount;

    public ESKnnFloatVectorQuery(String field, float[] target, Integer k, int numCands, Query filter) {
        super(field, target, numCands, filter);
        this.kParam = k;
    }

    protected TopDocs mergeLeafResults(TopDocs[] perLeafResults) {
        TopDocs topK = this.kParam == null ? super.mergeLeafResults(perLeafResults) : TopDocs.merge((int)this.kParam, (TopDocs[])perLeafResults);
        this.vectorOpsCount = topK.totalHits.value;
        return topK;
    }

    @Override
    public void profile(QueryProfiler queryProfiler) {
        queryProfiler.addVectorOpsCount(this.vectorOpsCount);
    }

    public Integer kParam() {
        return this.kParam;
    }
}

