/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.common.util.ObjectArrayPriorityQueue;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.BucketAndOrd;
import org.elasticsearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.BucketSignificancePriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.BytesKeyedBucketOrds;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.SignificanceLookup;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public final class MapStringTermsAggregator
extends AbstractStringTermsAggregator {
    private final CollectorSource collectorSource;
    private final ResultStrategy<?, ?> resultStrategy;
    private final BytesKeyedBucketOrds bucketOrds;
    private final IncludeExclude.StringFilter includeExclude;
    private final boolean excludeDeletedDocs;

    public MapStringTermsAggregator(String name, AggregatorFactories factories, CollectorSource collectorSource, Function<MapStringTermsAggregator, ResultStrategy<?, ?>> resultStrategy, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude.StringFilter includeExclude, AggregationContext context, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, CardinalityUpperBound cardinality, Map<String, Object> metadata, boolean excludeDeletedDocs) throws IOException {
        super(name, factories, context, parent, order, format, bucketCountThresholds, collectionMode, showTermDocCountError, metadata);
        this.resultStrategy = resultStrategy.apply(this);
        this.includeExclude = includeExclude;
        this.bucketOrds = BytesKeyedBucketOrds.build(context.bigArrays(), cardinality);
        this.collectorSource = collectorSource;
        this.excludeDeletedDocs = excludeDeletedDocs;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.collectorSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        return this.resultStrategy.wrapCollector(this.collectorSource.getLeafCollector(this.includeExclude, aggCtx.getLeafReaderContext(), sub, x$0 -> this.addRequestCircuitBreakerBytes(x$0), (s, doc, owningBucketOrd, bytes) -> {
            long bucketOrdinal = this.bucketOrds.add(owningBucketOrd, bytes);
            if (bucketOrdinal < 0L) {
                bucketOrdinal = -1L - bucketOrdinal;
                this.collectExistingBucket(s, doc, bucketOrdinal);
            } else {
                this.collectBucket(s, doc, bucketOrdinal);
            }
        }));
    }

    @Override
    public InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
        return this.resultStrategy.buildAggregations(owningBucketOrds);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.resultStrategy.buildEmptyResult();
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("total_buckets", this.bucketOrds.size());
        add.accept("collection_strategy", this.collectorSource.describe());
        this.collectorSource.collectDebugInfo(add);
        add.accept("result_strategy", this.resultStrategy.describe());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.collectorSource, this.resultStrategy, this.bucketOrds});
    }

    abstract class ResultStrategy<R extends InternalAggregation, B extends InternalMultiBucketAggregation.InternalBucket>
    implements Releasable {
        ResultStrategy() {
        }

        private InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
            try (LongArray otherDocCounts = MapStringTermsAggregator.this.bigArrays().newLongArray(owningBucketOrds.size(), true);){
                InternalAggregation[] internalAggregationArray;
                block37: {
                    ObjectArray<B[]> topBucketsPerOrd = this.buildTopBucketsPerOrd(Math.toIntExact(owningBucketOrds.size()));
                    try {
                        try (IntArray bucketsToCollect = MapStringTermsAggregator.this.bigArrays().newIntArray(owningBucketOrds.size());){
                            long ordsToCollect = 0L;
                            for (long ordIdx2 = 0L; ordIdx2 < owningBucketOrds.size(); ++ordIdx2) {
                                long owningBucketOrd = owningBucketOrds.get(ordIdx2);
                                this.collectZeroDocEntriesIfNeeded(owningBucketOrd, MapStringTermsAggregator.this.excludeDeletedDocs);
                                int size = (int)Math.min(MapStringTermsAggregator.this.bucketOrds.bucketsInOrd(owningBucketOrd), (long)MapStringTermsAggregator.this.bucketCountThresholds.getShardSize());
                                ordsToCollect += (long)size;
                                bucketsToCollect.set(ordIdx2, size);
                            }
                            try (LongArray ordsArray = MapStringTermsAggregator.this.bigArrays().newLongArray(ordsToCollect);){
                                long ordsCollected = 0L;
                                for (long ordIdx3 = 0L; ordIdx3 < topBucketsPerOrd.size(); ++ordIdx3) {
                                    long owningOrd = owningBucketOrds.get(ordIdx3);
                                    try (ObjectArrayPriorityQueue<BucketAndOrd<B>> ordered = this.buildPriorityQueue(bucketsToCollect.get(ordIdx3));){
                                        BucketAndOrd<B> spare = null;
                                        BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum = MapStringTermsAggregator.this.bucketOrds.ordsEnum(owningOrd);
                                        BucketUpdater<InternalMultiBucketAggregation.InternalBucket> bucketUpdater = this.bucketUpdater(owningOrd);
                                        while (ordsEnum.next()) {
                                            long docCount = MapStringTermsAggregator.this.bucketDocCount(ordsEnum.ord());
                                            otherDocCounts.increment(ordIdx3, docCount);
                                            if (docCount < MapStringTermsAggregator.this.bucketCountThresholds.getShardMinDocCount()) continue;
                                            if (spare == null) {
                                                MapStringTermsAggregator.this.checkRealMemoryCBForInternalBucket();
                                                spare = new BucketAndOrd<B>(this.buildEmptyBucket());
                                            }
                                            bucketUpdater.updateBucket((InternalMultiBucketAggregation.InternalBucket)spare.bucket, ordsEnum, docCount);
                                            spare.ord = ordsEnum.ord();
                                            spare = ordered.insertWithOverflow(spare);
                                        }
                                        int orderedSize = (int)ordered.size();
                                        InternalMultiBucketAggregation.InternalBucket[] buckets = this.buildBuckets(orderedSize);
                                        for (int i = orderedSize - 1; i >= 0; --i) {
                                            BucketAndOrd<B> bucketAndOrd = ordered.pop();
                                            this.finalizeBucket((InternalMultiBucketAggregation.InternalBucket)bucketAndOrd.bucket);
                                            buckets[i] = (InternalMultiBucketAggregation.InternalBucket)bucketAndOrd.bucket;
                                            ordsArray.set(ordsCollected + (long)i, bucketAndOrd.ord);
                                            otherDocCounts.increment(ordIdx3, -((InternalMultiBucketAggregation.InternalBucket)bucketAndOrd.bucket).getDocCount());
                                        }
                                        topBucketsPerOrd.set(ordIdx3, buckets);
                                        ordsCollected += (long)orderedSize;
                                        continue;
                                    }
                                }
                                assert (ordsCollected == ordsArray.size());
                                this.buildSubAggs(topBucketsPerOrd, ordsArray);
                            }
                        }
                        internalAggregationArray = MapStringTermsAggregator.this.buildAggregations(Math.toIntExact(owningBucketOrds.size()), ordIdx -> this.buildResult(owningBucketOrds.get(ordIdx), otherDocCounts.get(ordIdx), (InternalMultiBucketAggregation.InternalBucket[])topBucketsPerOrd.get(ordIdx)));
                        if (topBucketsPerOrd == null) break block37;
                    }
                    catch (Throwable throwable) {
                        if (topBucketsPerOrd != null) {
                            try {
                                topBucketsPerOrd.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    topBucketsPerOrd.close();
                }
                return internalAggregationArray;
            }
        }

        abstract String describe();

        abstract LeafBucketCollector wrapCollector(LeafBucketCollector var1);

        abstract void collectZeroDocEntriesIfNeeded(long var1, boolean var3) throws IOException;

        abstract B buildEmptyBucket();

        abstract ObjectArrayPriorityQueue<BucketAndOrd<B>> buildPriorityQueue(int var1);

        abstract BucketUpdater<B> bucketUpdater(long var1);

        abstract ObjectArray<B[]> buildTopBucketsPerOrd(long var1);

        abstract B[] buildBuckets(int var1);

        abstract void finalizeBucket(B var1);

        abstract void buildSubAggs(ObjectArray<B[]> var1, LongArray var2) throws IOException;

        abstract R buildResult(long var1, long var3, B[] var5);

        abstract R buildEmptyResult();
    }

    public static interface CollectorSource
    extends Releasable {
        public String describe();

        public void collectDebugInfo(BiConsumer<String, Object> var1);

        public boolean needsScores();

        public LeafBucketCollector getLeafCollector(IncludeExclude.StringFilter var1, LeafReaderContext var2, LeafBucketCollector var3, LongConsumer var4, CollectConsumer var5) throws IOException;
    }

    @FunctionalInterface
    public static interface CollectConsumer {
        public void accept(LeafBucketCollector var1, int var2, long var3, BytesRef var5) throws IOException;
    }

    class SignificantTermsResults
    extends ResultStrategy<SignificantStringTerms, SignificantStringTerms.Bucket> {
        private final SignificanceLookup.BackgroundFrequencyForBytes backgroundFrequencies;
        private final long supersetSize;
        private final SignificanceHeuristic significanceHeuristic;
        private LongArray subsetSizes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SignificantTermsResults(SignificanceLookup significanceLookup, SignificanceHeuristic significanceHeuristic, CardinalityUpperBound cardinality) {
            this.backgroundFrequencies = significanceLookup.bytesLookup(MapStringTermsAggregator.this.bigArrays(), cardinality);
            this.supersetSize = significanceLookup.supersetSize();
            this.significanceHeuristic = significanceHeuristic;
            boolean success = false;
            try {
                this.subsetSizes = MapStringTermsAggregator.this.bigArrays().newLongArray(1L, true);
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        @Override
        String describe() {
            return "significant_terms";
        }

        @Override
        LeafBucketCollector wrapCollector(LeafBucketCollector primary) {
            return new LeafBucketCollectorBase(primary, null){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    super.collect(doc, owningBucketOrd);
                    SignificantTermsResults.this.subsetSizes = MapStringTermsAggregator.this.bigArrays().grow(SignificantTermsResults.this.subsetSizes, owningBucketOrd + 1L);
                    SignificantTermsResults.this.subsetSizes.increment(owningBucketOrd, 1L);
                }
            };
        }

        @Override
        void collectZeroDocEntriesIfNeeded(long owningBucketOrd, boolean excludeDeletedDocs) throws IOException {
        }

        @Override
        SignificantStringTerms.Bucket buildEmptyBucket() {
            return new SignificantStringTerms.Bucket(new BytesRef(), 0L, 0L, null, MapStringTermsAggregator.this.format, 0.0);
        }

        @Override
        ObjectArrayPriorityQueue<BucketAndOrd<SignificantStringTerms.Bucket>> buildPriorityQueue(int size) {
            return new BucketSignificancePriorityQueue<SignificantStringTerms.Bucket>(size, MapStringTermsAggregator.this.bigArrays());
        }

        @Override
        BucketUpdater<SignificantStringTerms.Bucket> bucketUpdater(long owningBucketOrd) {
            long subsetSize = this.subsetSizes.get(owningBucketOrd);
            return (spare, ordsEnum, docCount) -> {
                ordsEnum.readValue(spare.termBytes);
                spare.subsetDf = docCount;
                spare.supersetDf = this.backgroundFrequencies.freq(spare.termBytes);
                spare.updateScore(this.significanceHeuristic, subsetSize, this.supersetSize);
            };
        }

        @Override
        ObjectArray<SignificantStringTerms.Bucket[]> buildTopBucketsPerOrd(long size) {
            return MapStringTermsAggregator.this.bigArrays().newObjectArray(size);
        }

        SignificantStringTerms.Bucket[] buildBuckets(int size) {
            return new SignificantStringTerms.Bucket[size];
        }

        @Override
        void finalizeBucket(SignificantStringTerms.Bucket bucket) {
            bucket.termBytes = BytesRef.deepCopyOf((BytesRef)bucket.termBytes);
        }

        @Override
        void buildSubAggs(ObjectArray<SignificantStringTerms.Bucket[]> topBucketsPerOrd, LongArray ordsArray) throws IOException {
            MapStringTermsAggregator.this.buildSubAggsForAllBuckets((ObjectArray<B[]>)topBucketsPerOrd, ordsArray, (b, a) -> {
                b.aggregations = a;
            });
        }

        SignificantStringTerms buildResult(long owningBucketOrd, long otherDocCount, SignificantStringTerms.Bucket[] topBuckets) {
            return new SignificantStringTerms(MapStringTermsAggregator.this.name, MapStringTermsAggregator.this.bucketCountThresholds.getRequiredSize(), MapStringTermsAggregator.this.bucketCountThresholds.getMinDocCount(), MapStringTermsAggregator.this.metadata(), MapStringTermsAggregator.this.format, this.subsetSizes.get(owningBucketOrd), this.supersetSize, this.significanceHeuristic, Arrays.asList(topBuckets));
        }

        @Override
        SignificantStringTerms buildEmptyResult() {
            return MapStringTermsAggregator.this.buildEmptySignificantTermsAggregation(0L, this.supersetSize, this.significanceHeuristic);
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.backgroundFrequencies, this.subsetSizes});
        }
    }

    class StandardTermsResults
    extends ResultStrategy<StringTerms, StringTerms.Bucket> {
        private final ValuesSource valuesSource;
        private final Comparator<BucketAndOrd<StringTerms.Bucket>> comparator;

        StandardTermsResults(ValuesSource valuesSource, Aggregator aggregator) {
            this.valuesSource = valuesSource;
            this.comparator = MapStringTermsAggregator.this.order.partiallyBuiltBucketComparator(aggregator);
        }

        @Override
        String describe() {
            return "terms";
        }

        @Override
        LeafBucketCollector wrapCollector(LeafBucketCollector primary) {
            return primary;
        }

        @Override
        void collectZeroDocEntriesIfNeeded(long owningBucketOrd, boolean excludeDeletedDocs) throws IOException {
            if (MapStringTermsAggregator.this.bucketCountThresholds.getMinDocCount() != 0L) {
                return;
            }
            if (InternalOrder.isCountDesc(MapStringTermsAggregator.this.order) && MapStringTermsAggregator.this.bucketOrds.bucketsInOrd(owningBucketOrd) >= (long)MapStringTermsAggregator.this.bucketCountThresholds.getRequiredSize()) {
                return;
            }
            for (LeafReaderContext ctx : MapStringTermsAggregator.this.searcher().getTopReaderContext().leaves()) {
                SortedBinaryDocValues values;
                Bits liveDocs;
                Bits bits = liveDocs = excludeDeletedDocs ? ctx.reader().getLiveDocs() : null;
                if (liveDocs == null && this.valuesSource.hasOrdinals()) {
                    values = ((ValuesSource.Bytes.WithOrdinals)this.valuesSource).ordinalsValues(ctx);
                    this.collectZeroDocEntries((SortedSetDocValues)values, owningBucketOrd);
                    continue;
                }
                values = this.valuesSource.bytesValues(ctx);
                BinaryDocValues singleton = FieldData.unwrapSingleton(values);
                if (singleton != null) {
                    this.collectZeroDocEntries(singleton, liveDocs, ctx.reader().maxDoc(), owningBucketOrd);
                    continue;
                }
                this.collectZeroDocEntries(values, liveDocs, ctx.reader().maxDoc(), owningBucketOrd);
            }
        }

        private void collectZeroDocEntries(SortedSetDocValues values, long owningBucketOrd) throws IOException {
            BytesRef term;
            TermsEnum termsEnum = values.termsEnum();
            while ((term = termsEnum.next()) != null) {
                if (MapStringTermsAggregator.this.includeExclude != null && !MapStringTermsAggregator.this.includeExclude.accept(term)) continue;
                MapStringTermsAggregator.this.bucketOrds.add(owningBucketOrd, term);
            }
        }

        private void collectZeroDocEntries(SortedBinaryDocValues values, Bits liveDocs, int maxDoc, long owningBucketOrd) throws IOException {
            for (int docId = 0; docId < maxDoc; ++docId) {
                if (liveDocs != null && !liveDocs.get(docId) || !values.advanceExact(docId)) continue;
                int valueCount = values.docValueCount();
                for (int i = 0; i < valueCount; ++i) {
                    BytesRef term = values.nextValue();
                    if (MapStringTermsAggregator.this.includeExclude != null && !MapStringTermsAggregator.this.includeExclude.accept(term)) continue;
                    MapStringTermsAggregator.this.bucketOrds.add(owningBucketOrd, term);
                }
            }
        }

        private void collectZeroDocEntries(BinaryDocValues values, Bits liveDocs, int maxDoc, long owningBucketOrd) throws IOException {
            for (int docId = 0; docId < maxDoc; ++docId) {
                if (liveDocs != null && !liveDocs.get(docId) || !values.advanceExact(docId)) continue;
                BytesRef term = values.binaryValue();
                if (MapStringTermsAggregator.this.includeExclude != null && !MapStringTermsAggregator.this.includeExclude.accept(term)) continue;
                MapStringTermsAggregator.this.bucketOrds.add(owningBucketOrd, term);
            }
        }

        @Override
        StringTerms.Bucket buildEmptyBucket() {
            return new StringTerms.Bucket(new BytesRef(), 0L, null, MapStringTermsAggregator.this.showTermDocCountError, 0L, MapStringTermsAggregator.this.format);
        }

        @Override
        ObjectArrayPriorityQueue<BucketAndOrd<StringTerms.Bucket>> buildPriorityQueue(int size) {
            return new BucketPriorityQueue<StringTerms.Bucket>(size, MapStringTermsAggregator.this.bigArrays(), this.comparator);
        }

        @Override
        BucketUpdater<StringTerms.Bucket> bucketUpdater(long owningBucketOrd) {
            return (spare, ordsEnum, docCount) -> {
                ordsEnum.readValue(spare.termBytes);
                spare.docCount = docCount;
            };
        }

        @Override
        ObjectArray<StringTerms.Bucket[]> buildTopBucketsPerOrd(long size) {
            return MapStringTermsAggregator.this.bigArrays().newObjectArray(size);
        }

        StringTerms.Bucket[] buildBuckets(int size) {
            return new StringTerms.Bucket[size];
        }

        @Override
        void finalizeBucket(StringTerms.Bucket bucket) {
            bucket.termBytes = BytesRef.deepCopyOf((BytesRef)bucket.termBytes);
        }

        @Override
        void buildSubAggs(ObjectArray<StringTerms.Bucket[]> topBucketsPerOrd, LongArray ordArray) throws IOException {
            MapStringTermsAggregator.this.buildSubAggsForAllBuckets((ObjectArray<B[]>)topBucketsPerOrd, ordArray, (b, a) -> {
                b.aggregations = a;
            });
        }

        StringTerms buildResult(long owningBucketOrd, long otherDocCount, StringTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(MapStringTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = MapStringTermsAggregator.this.order;
            }
            return new StringTerms(MapStringTermsAggregator.this.name, reduceOrder, MapStringTermsAggregator.this.order, MapStringTermsAggregator.this.bucketCountThresholds.getRequiredSize(), MapStringTermsAggregator.this.bucketCountThresholds.getMinDocCount(), MapStringTermsAggregator.this.metadata(), MapStringTermsAggregator.this.format, MapStringTermsAggregator.this.bucketCountThresholds.getShardSize(), MapStringTermsAggregator.this.showTermDocCountError, otherDocCount, Arrays.asList(topBuckets), null);
        }

        @Override
        StringTerms buildEmptyResult() {
            return MapStringTermsAggregator.this.buildEmptyTermsAggregation();
        }

        public void close() {
        }
    }

    static interface BucketUpdater<B extends InternalMultiBucketAggregation.InternalBucket> {
        public void updateBucket(B var1, BytesKeyedBucketOrds.BucketOrdsEnum var2, long var3) throws IOException;
    }

    public static class ValuesSourceCollectorSource
    implements CollectorSource {
        private final ValuesSourceConfig valuesSourceConfig;

        public ValuesSourceCollectorSource(ValuesSourceConfig valuesSourceConfig) {
            this.valuesSourceConfig = valuesSourceConfig;
        }

        @Override
        public String describe() {
            return "from " + this.valuesSourceConfig.getDescription();
        }

        @Override
        public void collectDebugInfo(BiConsumer<String, Object> add) {
        }

        @Override
        public boolean needsScores() {
            return this.valuesSourceConfig.getValuesSource().needsScores();
        }

        @Override
        public LeafBucketCollector getLeafCollector(IncludeExclude.StringFilter includeExclude, LeafReaderContext ctx, LeafBucketCollector sub, LongConsumer addRequestCircuitBreakerBytes, CollectConsumer consumer) throws IOException {
            SortedBinaryDocValues values = this.valuesSourceConfig.getValuesSource().bytesValues(ctx);
            BinaryDocValues singleton = FieldData.unwrapSingleton(values);
            return singleton != null ? this.getLeafCollector(includeExclude, singleton, sub, consumer) : this.getLeafCollector(includeExclude, values, sub, consumer);
        }

        private LeafBucketCollector getLeafCollector(final IncludeExclude.StringFilter includeExclude, final SortedBinaryDocValues values, final LeafBucketCollector sub, final CollectConsumer consumer) {
            return new LeafBucketCollectorBase(sub, values){
                final BytesRefBuilder previous;
                {
                    super(sub2, values2);
                    this.previous = new BytesRefBuilder();
                }

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    if (!values.advanceExact(doc)) {
                        return;
                    }
                    int valuesCount = values.docValueCount();
                    this.previous.clear();
                    for (int i = 0; i < valuesCount; ++i) {
                        BytesRef bytes = values.nextValue();
                        if (includeExclude != null && !includeExclude.accept(bytes) || i > 0 && this.previous.get().equals((Object)bytes)) continue;
                        this.previous.copyBytes(bytes);
                        consumer.accept(sub, doc, owningBucketOrd, bytes);
                    }
                }
            };
        }

        private LeafBucketCollector getLeafCollector(final IncludeExclude.StringFilter includeExclude, final BinaryDocValues values, final LeafBucketCollector sub, final CollectConsumer consumer) {
            return new LeafBucketCollectorBase(sub, values){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    if (values.advanceExact(doc)) {
                        BytesRef bytes = values.binaryValue();
                        if (includeExclude == null || includeExclude.accept(bytes)) {
                            consumer.accept(sub, doc, owningBucketOrd, bytes);
                        }
                    }
                }
            };
        }

        public void close() {
        }
    }
}

