/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.snapshots.Snapshot;

public class ShardSnapshotInfo
implements Writeable {
    private final IndexId indexId;
    private final Snapshot snapshot;
    private final ShardId shardId;
    private final String indexMetadataIdentifier;
    @Nullable
    private final String shardStateIdentifier;
    private final long startedAt;

    public ShardSnapshotInfo(IndexId indexId, ShardId shardId, Snapshot snapshot, String indexMetadataIdentifier, @Nullable String shardStateIdentifier, long startedAt) {
        this.indexId = indexId;
        this.shardId = shardId;
        this.snapshot = snapshot;
        this.indexMetadataIdentifier = indexMetadataIdentifier;
        this.shardStateIdentifier = shardStateIdentifier;
        this.startedAt = startedAt;
    }

    public ShardSnapshotInfo(StreamInput in) throws IOException {
        this.indexId = new IndexId(in);
        this.snapshot = new Snapshot(in);
        this.shardId = new ShardId(in);
        this.indexMetadataIdentifier = in.readString();
        this.shardStateIdentifier = in.readOptionalString();
        this.startedAt = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.indexId.writeTo(out);
        this.snapshot.writeTo(out);
        this.shardId.writeTo(out);
        out.writeString(this.indexMetadataIdentifier);
        out.writeOptionalString(this.shardStateIdentifier);
        out.writeLong(this.startedAt);
    }

    @Nullable
    public String getShardStateIdentifier() {
        return this.shardStateIdentifier;
    }

    public String getIndexMetadataIdentifier() {
        return this.indexMetadataIdentifier;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public String getRepository() {
        return this.snapshot.getRepository();
    }

    public IndexId getIndexId() {
        return this.indexId;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public long getStartedAt() {
        return this.startedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardSnapshotInfo that = (ShardSnapshotInfo)o;
        return this.startedAt == that.startedAt && Objects.equals(this.indexId, that.indexId) && Objects.equals(this.snapshot, that.snapshot) && Objects.equals(this.shardId, that.shardId) && Objects.equals(this.indexMetadataIdentifier, that.indexMetadataIdentifier) && Objects.equals(this.shardStateIdentifier, that.shardStateIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.indexId, this.snapshot, this.shardId, this.indexMetadataIdentifier, this.shardStateIdentifier, this.startedAt);
    }

    public String toString() {
        return "ShardSnapshotInfo{indexId=" + String.valueOf(this.indexId) + ", snapshot=" + String.valueOf(this.snapshot) + ", shardId=" + String.valueOf(this.shardId) + ", indexMetadataIdentifier='" + this.indexMetadataIdentifier + "', shardStateIdentifier='" + this.shardStateIdentifier + "', startedAt=" + this.startedAt + "}";
    }
}

