/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.util.function.Predicate;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public interface FieldPredicate
extends Accountable,
Predicate<String> {
    public static final FieldPredicate ACCEPT_ALL = new FieldPredicate(){

        @Override
        public boolean test(String field) {
            return true;
        }

        @Override
        public String modifyHash(String hash) {
            return hash;
        }

        public long ramBytesUsed() {
            return 0L;
        }

        public String toString() {
            return "accept all";
        }
    };

    @Override
    public boolean test(String var1);

    public String modifyHash(String var1);

    public static class And
    implements FieldPredicate {
        private static final long SHALLOW_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(And.class);
        private final FieldPredicate first;
        private final FieldPredicate second;

        public And(FieldPredicate first, FieldPredicate second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public boolean test(String field) {
            return this.first.test(field) && this.second.test(field);
        }

        @Override
        public String modifyHash(String hash) {
            return this.second.modifyHash(this.first.modifyHash(hash));
        }

        public long ramBytesUsed() {
            return SHALLOW_RAM_BYTES_USED + this.first.ramBytesUsed() + this.second.ramBytesUsed();
        }

        public String toString() {
            return String.valueOf(this.first) + " then " + String.valueOf(this.second);
        }
    }
}

