/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.RequestValidators;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.MappedActionFilter;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestHeaderDefinition;

public interface ActionPlugin {
    default public Collection<ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Collections.emptyList();
    }

    default public Collection<ActionFilter> getActionFilters() {
        return Collections.emptyList();
    }

    default public Collection<MappedActionFilter> getMappedActionFilters() {
        return Collections.emptyList();
    }

    default public Collection<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return Collections.emptyList();
    }

    default public Collection<RestHeaderDefinition> getRestHeaders() {
        return Collections.emptyList();
    }

    default public Collection<String> getTaskHeaders() {
        return Collections.emptyList();
    }

    default public Collection<RequestValidators.RequestValidator<PutMappingRequest>> mappingRequestValidators() {
        return Collections.emptyList();
    }

    default public Collection<RequestValidators.RequestValidator<IndicesAliasesRequest>> indicesAliasesRequestValidators() {
        return Collections.emptyList();
    }

    public static final class ActionHandler<Request extends ActionRequest, Response extends ActionResponse> {
        private final ActionType<Response> action;
        private final Class<? extends TransportAction<Request, Response>> transportAction;

        public ActionHandler(ActionType<Response> action, Class<? extends TransportAction<Request, Response>> transportAction) {
            this.action = action;
            this.transportAction = transportAction;
        }

        public ActionType<Response> getAction() {
            return this.action;
        }

        public Class<? extends TransportAction<Request, Response>> getTransportAction() {
            return this.transportAction;
        }

        public String toString() {
            return this.action.name() + " is handled by " + this.transportAction.getName();
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != ActionHandler.class) {
                return false;
            }
            ActionHandler other = (ActionHandler)obj;
            return Objects.equals(this.action, other.action) && Objects.equals(this.transportAction, other.transportAction);
        }

        public int hashCode() {
            return Objects.hash(this.action, this.transportAction);
        }
    }
}

