/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice;

import java.util.Locale;
import org.elasticsearch.injection.guice.Initializables;
import org.elasticsearch.injection.guice.InjectorImpl;
import org.elasticsearch.injection.guice.InternalFactoryToProviderAdapter;
import org.elasticsearch.injection.guice.Provider;
import org.elasticsearch.injection.guice.ProviderToInternalFactoryAdapter;
import org.elasticsearch.injection.guice.Scope;
import org.elasticsearch.injection.guice.internal.InternalFactory;
import org.elasticsearch.injection.guice.internal.Scoping;

public class Scopes {
    public static final Scope SINGLETON = new Scope(){

        @Override
        public <T> Provider<T> scope(final Provider<T> creator) {
            return new Provider<T>(){
                private volatile T instance;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public T get() {
                    if (this.instance != null) return this.instance;
                    Class<InjectorImpl> clazz = InjectorImpl.class;
                    synchronized (InjectorImpl.class) {
                        if (this.instance != null) return this.instance;
                        this.instance = creator.get();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return this.instance;
                    }
                }

                public String toString() {
                    return String.format(Locale.ROOT, "%s[%s]", creator, SINGLETON);
                }
            };
        }

        @Override
        public String toString() {
            return "Scopes.SINGLETON";
        }
    };
    public static final Scope NO_SCOPE = new Scope(){

        @Override
        public <T> Provider<T> scope(Provider<T> unscoped) {
            return unscoped;
        }

        @Override
        public String toString() {
            return "Scopes.NO_SCOPE";
        }
    };

    private Scopes() {
    }

    static <T> InternalFactory<? extends T> scope(InjectorImpl injector, InternalFactory<? extends T> creator, Scoping scoping) {
        if (scoping.isNoScope()) {
            return creator;
        }
        Scope scope = scoping.getScopeInstance();
        Provider<? extends T> scoped = scope.scope(new ProviderToInternalFactoryAdapter<T>(injector, creator));
        return new InternalFactoryToProviderAdapter<T>(Initializables.of(scoped));
    }
}

