/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.SlowLogFieldProvider;
import org.elasticsearch.index.SlowLogFields;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.mapper.MapperMetrics;
import org.elasticsearch.index.mapper.MapperRegistry;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.EnginePlugin;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.internal.InternalSearchPlugin;
import org.elasticsearch.plugins.internal.rewriter.QueryRewriteInterceptor;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class IndicesServiceBuilder {
    Settings settings;
    PluginsService pluginsService;
    NodeEnvironment nodeEnv;
    NamedXContentRegistry xContentRegistry;
    AnalysisRegistry analysisRegistry;
    IndexNameExpressionResolver indexNameExpressionResolver;
    MapperRegistry mapperRegistry;
    NamedWriteableRegistry namedWriteableRegistry;
    ThreadPool threadPool;
    IndexScopedSettings indexScopedSettings;
    CircuitBreakerService circuitBreakerService;
    BigArrays bigArrays;
    ScriptService scriptService;
    ClusterService clusterService;
    Client client;
    FeatureService featureService;
    MetaStateService metaStateService;
    Collection<Function<IndexSettings, Optional<EngineFactory>>> engineFactoryProviders = List.of();
    Map<String, IndexStorePlugin.DirectoryFactory> directoryFactories = Map.of();
    @Nullable
    ValuesSourceRegistry valuesSourceRegistry;
    Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories = Map.of();
    List<IndexStorePlugin.IndexFoldersDeletionListener> indexFoldersDeletionListeners = List.of();
    Map<String, IndexStorePlugin.SnapshotCommitSupplier> snapshotCommitSuppliers = Map.of();
    @Nullable
    CheckedBiConsumer<ShardSearchRequest, StreamOutput, IOException> requestCacheKeyDifferentiator;
    MapperMetrics mapperMetrics;
    List<SearchOperationListener> searchOperationListener = List.of();
    QueryRewriteInterceptor queryRewriteInterceptor = null;
    SlowLogFieldProvider slowLogFieldProvider = new SlowLogFieldProvider(){

        @Override
        public SlowLogFields create(IndexSettings indexSettings) {
            return new SlowLogFields(){

                @Override
                public Map<String, String> indexFields() {
                    return Map.of();
                }

                @Override
                public Map<String, String> searchFields() {
                    return Map.of();
                }
            };
        }
    };

    public IndicesServiceBuilder settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public IndicesServiceBuilder pluginsService(PluginsService pluginsService) {
        this.pluginsService = pluginsService;
        return this;
    }

    public IndicesServiceBuilder nodeEnvironment(NodeEnvironment nodeEnv) {
        this.nodeEnv = nodeEnv;
        return this;
    }

    public IndicesServiceBuilder xContentRegistry(NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
        return this;
    }

    public IndicesServiceBuilder analysisRegistry(AnalysisRegistry analysisRegistry) {
        this.analysisRegistry = analysisRegistry;
        return this;
    }

    public IndicesServiceBuilder indexNameExpressionResolver(IndexNameExpressionResolver indexNameExpressionResolver) {
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        return this;
    }

    public IndicesServiceBuilder mapperRegistry(MapperRegistry mapperRegistry) {
        this.mapperRegistry = mapperRegistry;
        return this;
    }

    public IndicesServiceBuilder namedWriteableRegistry(NamedWriteableRegistry namedWriteableRegistry) {
        this.namedWriteableRegistry = namedWriteableRegistry;
        return this;
    }

    public IndicesServiceBuilder threadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public IndicesServiceBuilder indexScopedSettings(IndexScopedSettings indexScopedSettings) {
        this.indexScopedSettings = indexScopedSettings;
        return this;
    }

    public IndicesServiceBuilder circuitBreakerService(CircuitBreakerService circuitBreakerService) {
        this.circuitBreakerService = circuitBreakerService;
        return this;
    }

    public IndicesServiceBuilder bigArrays(BigArrays bigArrays) {
        this.bigArrays = bigArrays;
        return this;
    }

    public IndicesServiceBuilder scriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
        return this;
    }

    public IndicesServiceBuilder clusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
        return this;
    }

    public IndicesServiceBuilder client(Client client) {
        this.client = client;
        return this;
    }

    public IndicesServiceBuilder featureService(FeatureService featureService) {
        this.featureService = featureService;
        return this;
    }

    public IndicesServiceBuilder metaStateService(MetaStateService metaStateService) {
        this.metaStateService = metaStateService;
        return this;
    }

    public IndicesServiceBuilder valuesSourceRegistry(ValuesSourceRegistry valuesSourceRegistry) {
        this.valuesSourceRegistry = valuesSourceRegistry;
        return this;
    }

    public IndicesServiceBuilder requestCacheKeyDifferentiator(CheckedBiConsumer<ShardSearchRequest, StreamOutput, IOException> requestCacheKeyDifferentiator) {
        this.requestCacheKeyDifferentiator = requestCacheKeyDifferentiator;
        return this;
    }

    public IndicesServiceBuilder mapperMetrics(MapperMetrics mapperMetrics) {
        this.mapperMetrics = mapperMetrics;
        return this;
    }

    public List<SearchOperationListener> searchOperationListeners() {
        return this.searchOperationListener;
    }

    public IndicesServiceBuilder searchOperationListeners(List<SearchOperationListener> searchOperationListener) {
        this.searchOperationListener = searchOperationListener;
        return this;
    }

    public IndicesServiceBuilder slowLogFieldProvider(SlowLogFieldProvider slowLogFieldProvider) {
        this.slowLogFieldProvider = slowLogFieldProvider;
        return this;
    }

    public IndicesService build() {
        Objects.requireNonNull(this.settings);
        Objects.requireNonNull(this.pluginsService);
        Objects.requireNonNull(this.nodeEnv);
        Objects.requireNonNull(this.xContentRegistry);
        Objects.requireNonNull(this.analysisRegistry);
        Objects.requireNonNull(this.indexNameExpressionResolver);
        Objects.requireNonNull(this.mapperRegistry);
        Objects.requireNonNull(this.namedWriteableRegistry);
        Objects.requireNonNull(this.threadPool);
        Objects.requireNonNull(this.indexScopedSettings);
        Objects.requireNonNull(this.circuitBreakerService);
        Objects.requireNonNull(this.bigArrays);
        Objects.requireNonNull(this.scriptService);
        Objects.requireNonNull(this.clusterService);
        Objects.requireNonNull(this.client);
        Objects.requireNonNull(this.featureService);
        Objects.requireNonNull(this.metaStateService);
        Objects.requireNonNull(this.engineFactoryProviders);
        Objects.requireNonNull(this.directoryFactories);
        Objects.requireNonNull(this.recoveryStateFactories);
        Objects.requireNonNull(this.indexFoldersDeletionListeners);
        Objects.requireNonNull(this.snapshotCommitSuppliers);
        Objects.requireNonNull(this.mapperMetrics);
        Objects.requireNonNull(this.searchOperationListener);
        Objects.requireNonNull(this.slowLogFieldProvider);
        this.engineFactoryProviders = this.pluginsService.filterPlugins(EnginePlugin.class).map(plugin -> plugin::getEngineFactory).toList();
        this.directoryFactories = this.pluginsService.filterPlugins(IndexStorePlugin.class).map(IndexStorePlugin::getDirectoryFactories).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.recoveryStateFactories = this.pluginsService.filterPlugins(IndexStorePlugin.class).map(IndexStorePlugin::getRecoveryStateFactories).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.indexFoldersDeletionListeners = this.pluginsService.filterPlugins(IndexStorePlugin.class).map(IndexStorePlugin::getIndexFoldersDeletionListeners).flatMap(Collection::stream).toList();
        this.snapshotCommitSuppliers = this.pluginsService.filterPlugins(IndexStorePlugin.class).map(IndexStorePlugin::getSnapshotCommitSuppliers).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, QueryRewriteInterceptor> queryRewriteInterceptors = this.pluginsService.filterPlugins(InternalSearchPlugin.class).map(InternalSearchPlugin::getQueryRewriteInterceptors).flatMap(Collection::stream).collect(Collectors.toMap(QueryRewriteInterceptor::getQueryName, interceptor -> {
            if (interceptor.getQueryName() == null) {
                throw new IllegalArgumentException("QueryRewriteInterceptor [" + interceptor.getClass().getName() + "] requires name");
            }
            return interceptor;
        }, (a, b) -> {
            throw new IllegalStateException("Conflicting rewrite interceptors [" + a.getQueryName() + "] found in [" + a.getClass().getName() + "] and [" + b.getClass().getName() + "]");
        }));
        this.queryRewriteInterceptor = QueryRewriteInterceptor.multi(queryRewriteInterceptors);
        return new IndicesService(this);
    }
}

