/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportRequest;

public abstract class AbstractBulkByScrollRequest<Self extends AbstractBulkByScrollRequest<Self>>
extends ActionRequest {
    public static final int MAX_DOCS_ALL_MATCHES = -1;
    public static final TimeValue DEFAULT_SCROLL_TIMEOUT = TimeValue.timeValueMinutes((long)5L);
    public static final int DEFAULT_SCROLL_SIZE = 1000;
    public static final int AUTO_SLICES = 0;
    public static final String AUTO_SLICES_VALUE = "auto";
    private static final int DEFAULT_SLICES = 1;
    private final SearchRequest searchRequest;
    private int maxDocs = -1;
    private boolean abortOnVersionConflict = true;
    private boolean refresh = false;
    private TimeValue timeout = ReplicationRequest.DEFAULT_TIMEOUT;
    private ActiveShardCount activeShardCount = ActiveShardCount.DEFAULT;
    private TimeValue retryBackoffInitialTime = TimeValue.timeValueMillis((long)500L);
    private int maxRetries = 11;
    private float requestsPerSecond = Float.POSITIVE_INFINITY;
    private boolean shouldStoreResult;
    private int slices = 1;

    public AbstractBulkByScrollRequest(StreamInput in) throws IOException {
        super(in);
        this.searchRequest = new SearchRequest(in);
        this.abortOnVersionConflict = in.readBoolean();
        this.maxDocs = in.readVInt();
        this.refresh = in.readBoolean();
        this.timeout = in.readTimeValue();
        this.activeShardCount = ActiveShardCount.readFrom(in);
        this.retryBackoffInitialTime = in.readTimeValue();
        this.maxRetries = in.readVInt();
        this.requestsPerSecond = in.readFloat();
        this.slices = in.readVInt();
    }

    public AbstractBulkByScrollRequest(SearchRequest searchRequest, boolean setDefaults) {
        this.searchRequest = searchRequest;
        if (setDefaults) {
            searchRequest.scroll(DEFAULT_SCROLL_TIMEOUT);
            searchRequest.source(new SearchSourceBuilder());
            searchRequest.source().size(1000);
        }
    }

    protected abstract Self self();

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException e = this.searchRequest.validate();
        if (this.searchRequest.source().from() != -1) {
            e = ValidateActions.addValidationError("from is not supported in this context", e);
        }
        if (this.searchRequest.source().storedFields() != null) {
            e = ValidateActions.addValidationError("stored_fields is not supported in this context", e);
        }
        if (this.maxRetries < 0) {
            e = ValidateActions.addValidationError("retries cannot be negative", e);
        }
        if (!(this.maxDocs == -1 || this.maxDocs > 0)) {
            e = ValidateActions.addValidationError("maxDocs should be greater than 0 if the request is limited to some number of documents or -1 if it isn't but it was [" + this.maxDocs + "]", e);
        }
        if (this.searchRequest.source().slice() != null && this.slices != 1) {
            e = ValidateActions.addValidationError("can't specify both manual and automatic slicing at the same time", e);
        }
        return e;
    }

    public int getMaxDocs() {
        return this.maxDocs;
    }

    public Self setMaxDocs(int maxDocs) {
        if (maxDocs < 0) {
            throw new IllegalArgumentException("[max_docs] parameter cannot be negative, found [" + maxDocs + "]");
        }
        if (maxDocs < this.slices) {
            throw new IllegalArgumentException("[max_docs] should be >= [slices]");
        }
        this.maxDocs = maxDocs;
        return this.self();
    }

    public boolean isAbortOnVersionConflict() {
        return this.abortOnVersionConflict;
    }

    public Self setAbortOnVersionConflict(boolean abortOnVersionConflict) {
        this.abortOnVersionConflict = abortOnVersionConflict;
        return this.self();
    }

    public void setConflicts(String conflicts) {
        switch (conflicts) {
            case "proceed": {
                this.setAbortOnVersionConflict(false);
                break;
            }
            case "abort": {
                this.setAbortOnVersionConflict(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("conflicts may only be \"proceed\" or \"abort\" but was [" + conflicts + "]");
            }
        }
    }

    public SearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public Self setRefresh(boolean refresh) {
        this.refresh = refresh;
        return this.self();
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public Self setTimeout(TimeValue timeout) {
        this.timeout = Objects.requireNonNull(timeout);
        return this.self();
    }

    public ActiveShardCount getWaitForActiveShards() {
        return this.activeShardCount;
    }

    public Self setWaitForActiveShards(ActiveShardCount activeShardCount) {
        this.activeShardCount = activeShardCount;
        return this.self();
    }

    public Self setWaitForActiveShards(int waitForActiveShards) {
        return this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public TimeValue getRetryBackoffInitialTime() {
        return this.retryBackoffInitialTime;
    }

    public Self setRetryBackoffInitialTime(TimeValue retryBackoffInitialTime) {
        this.retryBackoffInitialTime = retryBackoffInitialTime;
        return this.self();
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Self setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this.self();
    }

    public float getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    public Self setRequestsPerSecond(float requestsPerSecond) {
        if (requestsPerSecond <= 0.0f) {
            throw new IllegalArgumentException("[requests_per_second] must be greater than 0. Use Float.POSITIVE_INFINITY to disable throttling.");
        }
        this.requestsPerSecond = requestsPerSecond;
        return this.self();
    }

    public Self setShouldStoreResult(boolean shouldStoreResult) {
        this.shouldStoreResult = shouldStoreResult;
        return this.self();
    }

    @Override
    public boolean getShouldStoreResult() {
        return this.shouldStoreResult;
    }

    public Self setScroll(TimeValue keepAlive) {
        this.searchRequest.scroll(new Scroll(keepAlive));
        return this.self();
    }

    public TimeValue getScrollTime() {
        return this.searchRequest.scroll().keepAlive();
    }

    public Self setSlices(int slices) {
        if (slices < 0) {
            throw new IllegalArgumentException("[slices] must be at least 0 but was [" + slices + "]");
        }
        this.slices = slices;
        return this.self();
    }

    public int getSlices() {
        return this.slices;
    }

    public abstract Self forSlice(TaskId var1, SearchRequest var2, int var3);

    protected Self doForSlice(Self request, TaskId slicingTask, int totalSlices) {
        if (totalSlices < 1) {
            throw new IllegalArgumentException("Number of total slices must be at least 1 but was [" + totalSlices + "]");
        }
        ((AbstractBulkByScrollRequest)((AbstractBulkByScrollRequest)((AbstractBulkByScrollRequest)((AbstractBulkByScrollRequest)((AbstractBulkByScrollRequest)((AbstractBulkByScrollRequest)((AbstractBulkByScrollRequest)((AbstractBulkByScrollRequest)((AbstractBulkByScrollRequest)request).setAbortOnVersionConflict(this.abortOnVersionConflict)).setRefresh(this.refresh)).setTimeout(this.timeout)).setWaitForActiveShards(this.activeShardCount)).setRetryBackoffInitialTime(this.retryBackoffInitialTime)).setMaxRetries(this.maxRetries)).setShouldStoreResult(false)).setRequestsPerSecond(this.requestsPerSecond / (float)totalSlices)).setSlices(1);
        if (this.maxDocs != -1) {
            ((AbstractBulkByScrollRequest)request).setMaxDocs(this.maxDocs / totalSlices);
        }
        ((TransportRequest)request).setParentTask(slicingTask);
        return request;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new BulkByScrollTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.searchRequest.writeTo(out);
        out.writeBoolean(this.abortOnVersionConflict);
        out.writeVInt(this.maxDocs);
        out.writeBoolean(this.refresh);
        out.writeTimeValue(this.timeout);
        this.activeShardCount.writeTo(out);
        out.writeTimeValue(this.retryBackoffInitialTime);
        out.writeVInt(this.maxRetries);
        out.writeFloat(this.requestsPerSecond);
        out.writeVInt(this.slices);
    }

    protected void searchToString(StringBuilder b) {
        if (this.searchRequest.indices() != null && this.searchRequest.indices().length != 0) {
            b.append(Arrays.toString(this.searchRequest.indices()));
        } else {
            b.append("[all indices]");
        }
    }

    @Override
    public String getDescription() {
        return this.toString();
    }
}

