/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum Operator implements Writeable
{
    OR,
    AND;


    public BooleanClause.Occur toBooleanClauseOccur() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case OR -> BooleanClause.Occur.SHOULD;
            case AND -> BooleanClause.Occur.MUST;
        };
    }

    public QueryParser.Operator toQueryParserOperator() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case OR -> QueryParser.Operator.OR;
            case AND -> QueryParser.Operator.AND;
        };
    }

    public static Operator readFromStream(StreamInput in) throws IOException {
        return in.readEnum(Operator.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this);
    }

    public static Operator fromString(String op) {
        return Operator.valueOf(op.toUpperCase(Locale.ROOT));
    }
}

