/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.DateTimeException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.BooleanFieldMapper;
import org.elasticsearch.index.mapper.BooleanScriptFieldType;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DateScriptFieldType;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DoubleScriptFieldType;
import org.elasticsearch.index.mapper.DynamicTemplate;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.KeywordScriptFieldType;
import org.elasticsearch.index.mapper.LongScriptFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.xcontent.XContentParser;

final class DynamicFieldsBuilder {
    private static final Concrete CONCRETE = new Concrete(DocumentParser::parseObjectOrField);
    static final DynamicFieldsBuilder DYNAMIC_TRUE = new DynamicFieldsBuilder(CONCRETE);
    static final DynamicFieldsBuilder DYNAMIC_RUNTIME = new DynamicFieldsBuilder(new Runtime());
    private final Strategy strategy;

    private DynamicFieldsBuilder(Strategy strategy) {
        this.strategy = strategy;
    }

    boolean createDynamicFieldFromValue(DocumentParserContext context, String name) throws IOException {
        XContentParser.Token token = context.parser().currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            String text = context.parser().text();
            boolean parseableAsLong = false;
            try {
                Long.parseLong(text);
                parseableAsLong = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            boolean parseableAsDouble = false;
            try {
                Double.parseDouble(text);
                parseableAsDouble = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (parseableAsLong && context.root().numericDetection()) {
                return DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.LONG, () -> this.strategy.newDynamicLongField(context, name));
            }
            if (parseableAsDouble && context.root().numericDetection()) {
                return DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.DOUBLE, () -> this.strategy.newDynamicDoubleField(context, name));
            }
            if (!parseableAsLong && !parseableAsDouble && context.root().dateDetection()) {
                for (DateFormatter dateTimeFormatter : context.root().dynamicDateTimeFormatters()) {
                    try {
                        dateTimeFormatter.parseMillis(text);
                    }
                    catch (IllegalArgumentException | DateTimeException | ElasticsearchParseException e) {
                        continue;
                    }
                    return DynamicFieldsBuilder.createDynamicDateField(context, name, dateTimeFormatter, () -> this.strategy.newDynamicDateField(context, name, dateTimeFormatter));
                }
                return DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.STRING, () -> this.strategy.newDynamicStringField(context, name));
            }
            return DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.STRING, () -> this.strategy.newDynamicStringField(context, name));
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            XContentParser.NumberType numberType = context.parser().numberType();
            if (numberType == XContentParser.NumberType.INT || numberType == XContentParser.NumberType.LONG || numberType == XContentParser.NumberType.BIG_INTEGER) {
                return DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.LONG, () -> this.strategy.newDynamicLongField(context, name));
            }
            if (numberType == XContentParser.NumberType.FLOAT || numberType == XContentParser.NumberType.DOUBLE || numberType == XContentParser.NumberType.BIG_DECIMAL) {
                return DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.DOUBLE, () -> this.strategy.newDynamicDoubleField(context, name));
            }
            throw new IllegalStateException("Unable to parse number of type [" + String.valueOf(numberType) + "]");
        }
        if (token == XContentParser.Token.VALUE_BOOLEAN) {
            return DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.BOOLEAN, () -> this.strategy.newDynamicBooleanField(context, name));
        }
        if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
            return DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.BINARY, () -> CONCRETE.newDynamicBinaryField(context, name));
        }
        return DynamicFieldsBuilder.createDynamicStringFieldFromTemplate(context, name);
    }

    static Mapper createDynamicObjectMapper(DocumentParserContext context, String name) {
        Mapper mapper = DynamicFieldsBuilder.createObjectMapperFromTemplate(context, name);
        return mapper != null ? mapper : new ObjectMapper.Builder(name, context.parent().subobjects).enabled(true).build(context.createDynamicMapperBuilderContext());
    }

    static Mapper createObjectMapperFromTemplate(DocumentParserContext context, String name) {
        Mapper.Builder templateBuilder = DynamicFieldsBuilder.findTemplateBuilderForObject(context, name);
        return templateBuilder == null ? null : templateBuilder.build(context.createDynamicMapperBuilderContext());
    }

    static boolean createDynamicStringFieldFromTemplate(DocumentParserContext context, String name) throws IOException {
        return DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.STRING, () -> false);
    }

    private static boolean createDynamicDateField(DocumentParserContext context, String name, DateFormatter dateFormatter, CheckedSupplier<Boolean, IOException> createDynamicField) throws IOException {
        return DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.DATE, dateFormatter, createDynamicField);
    }

    private static boolean createDynamicField(DocumentParserContext context, String name, DynamicTemplate.XContentFieldType matchType, CheckedSupplier<Boolean, IOException> dynamicFieldStrategy) throws IOException {
        assert (matchType != DynamicTemplate.XContentFieldType.DATE);
        return DynamicFieldsBuilder.createDynamicField(context, name, matchType, null, dynamicFieldStrategy);
    }

    private static boolean createDynamicField(DocumentParserContext context, String name, DynamicTemplate.XContentFieldType matchType, DateFormatter dateFormatter, CheckedSupplier<Boolean, IOException> dynamicFieldStrategy) throws IOException {
        if (DynamicFieldsBuilder.applyMatchingTemplate(context, name, matchType, dateFormatter)) {
            context.markFieldAsAppliedFromTemplate(name);
            return true;
        }
        return dynamicFieldStrategy.get();
    }

    private static boolean applyMatchingTemplate(DocumentParserContext context, String name, DynamicTemplate.XContentFieldType matchType, DateFormatter dateFormatter) throws IOException {
        DynamicTemplate dynamicTemplate = context.findDynamicTemplate(name, matchType);
        if (dynamicTemplate == null) {
            return false;
        }
        String dynamicType = dynamicTemplate.isRuntimeMapping() ? matchType.defaultRuntimeMappingType() : matchType.defaultMappingType();
        String mappingType = dynamicTemplate.mappingType(dynamicType);
        Map<String, Object> mapping = dynamicTemplate.mappingForName(name, dynamicType);
        if (dynamicTemplate.isRuntimeMapping()) {
            MappingParserContext parserContext = context.dynamicTemplateParserContext(dateFormatter);
            RuntimeField.Parser parser = parserContext.runtimeFieldParser(mappingType);
            String fullName = context.path().pathAsText(name);
            if (parser == null) {
                throw new MapperParsingException("failed to find type parsed [" + mappingType + "] for [" + fullName + "]");
            }
            RuntimeField.Builder builder = parser.parse(fullName, mapping, parserContext);
            Runtime.createDynamicField(builder.createRuntimeField(parserContext), context);
        } else {
            Mapper.Builder builder = DynamicFieldsBuilder.parseDynamicTemplateMapping(name, mappingType, mapping, dateFormatter, context);
            CONCRETE.createDynamicField(builder, context);
        }
        return true;
    }

    private static Mapper.Builder findTemplateBuilderForObject(DocumentParserContext context, String name) {
        DynamicTemplate.XContentFieldType matchType = DynamicTemplate.XContentFieldType.OBJECT;
        DynamicTemplate dynamicTemplate = context.findDynamicTemplate(name, matchType);
        if (dynamicTemplate == null) {
            return null;
        }
        String dynamicType = matchType.defaultMappingType();
        String mappingType = dynamicTemplate.mappingType(dynamicType);
        Map<String, Object> mapping = dynamicTemplate.mappingForName(name, dynamicType);
        return DynamicFieldsBuilder.parseDynamicTemplateMapping(name, mappingType, mapping, null, context);
    }

    private static Mapper.Builder parseDynamicTemplateMapping(String name, String mappingType, Map<String, Object> mapping, DateFormatter dateFormatter, DocumentParserContext context) {
        MappingParserContext parserContext = context.dynamicTemplateParserContext(dateFormatter);
        Mapper.TypeParser typeParser = parserContext.typeParser(mappingType);
        if (typeParser == null) {
            throw new MapperParsingException("failed to find type parsed [" + mappingType + "] for [" + name + "]");
        }
        return typeParser.parse(name, mapping, parserContext);
    }

    private static interface Strategy {
        public boolean newDynamicStringField(DocumentParserContext var1, String var2) throws IOException;

        public boolean newDynamicLongField(DocumentParserContext var1, String var2) throws IOException;

        public boolean newDynamicDoubleField(DocumentParserContext var1, String var2) throws IOException;

        public boolean newDynamicBooleanField(DocumentParserContext var1, String var2) throws IOException;

        public boolean newDynamicDateField(DocumentParserContext var1, String var2, DateFormatter var3) throws IOException;
    }

    private static final class Runtime
    implements Strategy {
        private Runtime() {
        }

        static boolean createDynamicField(RuntimeField runtimeField, DocumentParserContext context) {
            return context.addDynamicRuntimeField(runtimeField);
        }

        @Override
        public boolean newDynamicStringField(DocumentParserContext context, String name) {
            String fullName = context.path().pathAsText(name);
            return Runtime.createDynamicField(KeywordScriptFieldType.sourceOnly(fullName), context);
        }

        @Override
        public boolean newDynamicLongField(DocumentParserContext context, String name) {
            String fullName = context.path().pathAsText(name);
            return Runtime.createDynamicField(LongScriptFieldType.sourceOnly(fullName), context);
        }

        @Override
        public boolean newDynamicDoubleField(DocumentParserContext context, String name) {
            String fullName = context.path().pathAsText(name);
            return Runtime.createDynamicField(DoubleScriptFieldType.sourceOnly(fullName), context);
        }

        @Override
        public boolean newDynamicBooleanField(DocumentParserContext context, String name) {
            String fullName = context.path().pathAsText(name);
            return Runtime.createDynamicField(BooleanScriptFieldType.sourceOnly(fullName), context);
        }

        @Override
        public boolean newDynamicDateField(DocumentParserContext context, String name, DateFormatter dateFormatter) {
            String fullName = context.path().pathAsText(name);
            MappingParserContext parserContext = context.dynamicTemplateParserContext(dateFormatter);
            return Runtime.createDynamicField(DateScriptFieldType.sourceOnly(fullName, dateFormatter, parserContext.indexVersionCreated()), context);
        }
    }

    private static final class Concrete
    implements Strategy {
        private final CheckedBiConsumer<DocumentParserContext, Mapper, IOException> parseField;

        Concrete(CheckedBiConsumer<DocumentParserContext, Mapper, IOException> parseField) {
            this.parseField = parseField;
        }

        boolean createDynamicField(Mapper.Builder builder, DocumentParserContext context, MapperBuilderContext mapperBuilderContext) throws IOException {
            Mapper mapper = builder.build(mapperBuilderContext);
            if (context.addDynamicMapper(mapper)) {
                this.parseField.accept(context, mapper);
                return true;
            }
            return false;
        }

        boolean createDynamicField(Mapper.Builder builder, DocumentParserContext context) throws IOException {
            return this.createDynamicField(builder, context, context.createDynamicMapperBuilderContext());
        }

        @Override
        public boolean newDynamicStringField(DocumentParserContext context, String name) throws IOException {
            MapperBuilderContext mapperBuilderContext = context.createDynamicMapperBuilderContext();
            if (mapperBuilderContext.parentObjectContainsDimensions()) {
                return this.createDynamicField(new KeywordFieldMapper.Builder(name, context.indexSettings().getIndexVersionCreated()), context, mapperBuilderContext);
            }
            return this.createDynamicField(new TextFieldMapper.Builder(name, context.indexAnalyzers(), SourceFieldMapper.isSynthetic(context.indexSettings())).addMultiField(new KeywordFieldMapper.Builder("keyword", context.indexSettings().getIndexVersionCreated()).ignoreAbove(256)), context);
        }

        @Override
        public boolean newDynamicLongField(DocumentParserContext context, String name) throws IOException {
            return this.createDynamicField(new NumberFieldMapper.Builder(name, NumberFieldMapper.NumberType.LONG, ScriptCompiler.NONE, context.indexSettings().getSettings(), context.indexSettings().getIndexVersionCreated(), context.indexSettings().getMode()), context);
        }

        @Override
        public boolean newDynamicDoubleField(DocumentParserContext context, String name) throws IOException {
            return this.createDynamicField(new NumberFieldMapper.Builder(name, NumberFieldMapper.NumberType.FLOAT, ScriptCompiler.NONE, context.indexSettings().getSettings(), context.indexSettings().getIndexVersionCreated(), context.indexSettings().getMode()), context);
        }

        @Override
        public boolean newDynamicBooleanField(DocumentParserContext context, String name) throws IOException {
            Settings settings = context.indexSettings().getSettings();
            boolean ignoreMalformed = FieldMapper.IGNORE_MALFORMED_SETTING.get(settings);
            return this.createDynamicField(new BooleanFieldMapper.Builder(name, ScriptCompiler.NONE, ignoreMalformed, context.indexSettings().getIndexVersionCreated()), context);
        }

        @Override
        public boolean newDynamicDateField(DocumentParserContext context, String name, DateFormatter dateTimeFormatter) throws IOException {
            Settings settings = context.indexSettings().getSettings();
            boolean ignoreMalformed = FieldMapper.IGNORE_MALFORMED_SETTING.get(settings);
            return this.createDynamicField(new DateFieldMapper.Builder(name, DateFieldMapper.Resolution.MILLISECONDS, dateTimeFormatter, ScriptCompiler.NONE, ignoreMalformed, context.indexSettings().getIndexVersionCreated()), context);
        }

        boolean newDynamicBinaryField(DocumentParserContext context, String name) throws IOException {
            return this.createDynamicField(new BinaryFieldMapper.Builder(name, SourceFieldMapper.isSynthetic(context.indexSettings())), context);
        }
    }
}

