/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;

public class CustomFieldsVisitor
extends FieldsVisitor {
    private final Set<String> fields;

    public CustomFieldsVisitor(Set<String> fields, boolean loadSource) {
        super(loadSource);
        this.fields = new HashSet<String>(fields);
        FieldsVisitor.BASE_REQUIRED_FIELDS.forEach(this.fields::remove);
        this.fields.remove(this.sourceFieldName);
        this.fields.remove("_ignored");
    }

    @Override
    public Set<String> getFieldNames() {
        HashSet<String> fields = new HashSet<String>(super.getFieldNames());
        fields.addAll(this.fields);
        return fields;
    }

    @Override
    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
        if (this.fields.isEmpty()) {
            return super.needsField(fieldInfo);
        }
        if (super.needsField(fieldInfo) == StoredFieldVisitor.Status.YES) {
            return StoredFieldVisitor.Status.YES;
        }
        if (this.fields.contains(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        return StoredFieldVisitor.Status.NO;
    }
}

