/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.KeyedLock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.engine.DeleteVersionValue;
import org.elasticsearch.index.engine.IndexVersionValue;
import org.elasticsearch.index.engine.LiveVersionMapArchive;
import org.elasticsearch.index.engine.VersionValue;

public final class LiveVersionMap
implements ReferenceManager.RefreshListener,
Accountable {
    private final KeyedLock<BytesRef> keyedLock = new KeyedLock();
    private final LiveVersionMapArchive archive;
    private final Map<BytesRef, DeleteVersionValue> tombstones = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private volatile Maps maps = new Maps();
    private volatile Maps unsafeKeysMap = new Maps();
    private static final long BASE_BYTES_PER_BYTESREF = RamUsageEstimator.shallowSizeOfInstance(BytesRef.class) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 3L;
    private static final long BASE_BYTES_PER_CHM_ENTRY;
    private final AtomicLong ramBytesUsedForTombstones = new AtomicLong();

    LiveVersionMap() {
        this(LiveVersionMapArchive.NOOP_ARCHIVE);
    }

    LiveVersionMap(LiveVersionMapArchive archive) {
        this.archive = archive;
    }

    public void beforeRefresh() throws IOException {
        this.maps = this.maps.buildTransitionMap();
        assert ((this.unsafeKeysMap = this.unsafeKeysMap.buildTransitionMap()) != null);
    }

    public void afterRefresh(boolean didRefresh) throws IOException {
        this.maps = this.maps.invalidateOldMap(this.archive);
        assert ((this.unsafeKeysMap = this.unsafeKeysMap.invalidateOldMapForAssert()) != null);
    }

    VersionValue getUnderLock(BytesRef uid) {
        return this.getUnderLock(uid, this.maps);
    }

    private VersionValue getUnderLock(BytesRef uid, Maps currentMaps) {
        assert (this.assertKeyedLockHeldByCurrentThread(uid));
        VersionValue value = currentMaps.current.get(uid);
        if (value != null) {
            return value;
        }
        value = currentMaps.old.get(uid);
        if (value != null) {
            return value;
        }
        value = this.tombstones.get(uid);
        if (value != null) {
            return value;
        }
        return this.archive.get(uid);
    }

    VersionValue getVersionForAssert(BytesRef uid) {
        VersionValue value = this.getUnderLock(uid, this.maps);
        if (value == null) {
            value = this.getUnderLock(uid, this.unsafeKeysMap);
        }
        return value;
    }

    boolean isUnsafe() {
        return this.maps.current.isUnsafe() || this.maps.old.isUnsafe() || this.archive.isUnsafe();
    }

    void enforceSafeAccess() {
        this.maps.needsSafeAccess = true;
    }

    boolean isSafeAccessRequired() {
        return this.maps.isSafeAccessMode();
    }

    void maybePutIndexUnderLock(BytesRef uid, IndexVersionValue version) {
        assert (this.assertKeyedLockHeldByCurrentThread(uid));
        Maps maps = this.maps;
        if (maps.isSafeAccessMode()) {
            this.putIndexUnderLock(uid, version);
        } else {
            this.removeTombstoneUnderLock(uid);
            maps.current.markAsUnsafe();
            assert (this.putAssertionMap(uid, version));
        }
    }

    void putIndexUnderLock(BytesRef uid, IndexVersionValue version) {
        assert (this.assertKeyedLockHeldByCurrentThread(uid));
        assert (uid.bytes.length == uid.length) : "Oversized _uid! UID length: " + uid.length + ", bytes length: " + uid.bytes.length;
        this.maps.put(uid, version);
        this.removeTombstoneUnderLock(uid);
    }

    private boolean putAssertionMap(BytesRef uid, IndexVersionValue version) {
        assert (this.assertKeyedLockHeldByCurrentThread(uid));
        assert (uid.bytes.length == uid.length) : "Oversized _uid! UID length: " + uid.length + ", bytes length: " + uid.bytes.length;
        this.unsafeKeysMap.put(uid, version);
        return true;
    }

    void putDeleteUnderLock(BytesRef uid, DeleteVersionValue version) {
        assert (this.assertKeyedLockHeldByCurrentThread(uid));
        assert (uid.bytes.length == uid.length) : "Oversized _uid! UID length: " + uid.length + ", bytes length: " + uid.bytes.length;
        this.putTombstone(uid, version);
        this.maps.remove(uid, version);
    }

    private void putTombstone(BytesRef uid, DeleteVersionValue version) {
        long uidRamBytesUsed = BASE_BYTES_PER_BYTESREF + (long)uid.bytes.length;
        VersionValue prevTombstone = this.tombstones.put(uid, version);
        long ramBytes = BASE_BYTES_PER_CHM_ENTRY + version.ramBytesUsed() + uidRamBytesUsed;
        if (prevTombstone != null) {
            ramBytes -= BASE_BYTES_PER_CHM_ENTRY + prevTombstone.ramBytesUsed() + uidRamBytesUsed;
        }
        if (ramBytes != 0L) {
            long v = this.ramBytesUsedForTombstones.addAndGet(ramBytes);
            assert (v >= 0L) : "bytes=" + v;
        }
    }

    void removeTombstoneUnderLock(BytesRef uid) {
        assert (this.assertKeyedLockHeldByCurrentThread(uid));
        long uidRamBytesUsed = BASE_BYTES_PER_BYTESREF + (long)uid.bytes.length;
        VersionValue prev = this.tombstones.remove(uid);
        if (prev != null) {
            assert (prev.isDelete());
            long v = this.ramBytesUsedForTombstones.addAndGet(-(BASE_BYTES_PER_CHM_ENTRY + prev.ramBytesUsed() + uidRamBytesUsed));
            assert (v >= 0L) : "bytes=" + v;
        }
    }

    private boolean canRemoveTombstone(long maxTimestampToPrune, long maxSeqNoToPrune, DeleteVersionValue versionValue) {
        boolean isTooOld = versionValue.time < maxTimestampToPrune;
        boolean isSafeToPrune = versionValue.seqNo <= maxSeqNoToPrune;
        boolean isNotTrackedByCurrentMaps = versionValue.time < this.maps.getMinDeleteTimestamp();
        boolean isNotTrackedByArchive = versionValue.time < this.archive.getMinDeleteTimestamp();
        return isTooOld && isSafeToPrune && isNotTrackedByCurrentMaps & isNotTrackedByArchive;
    }

    void pruneTombstones(long maxTimestampToPrune, long maxSeqNoToPrune) {
        for (Map.Entry<BytesRef, DeleteVersionValue> entry : this.tombstones.entrySet()) {
            if (!this.canRemoveTombstone(maxTimestampToPrune, maxSeqNoToPrune, entry.getValue())) continue;
            BytesRef uid = entry.getKey();
            Releasable lock = this.keyedLock.tryAcquire(uid);
            try {
                DeleteVersionValue versionValue;
                if (lock == null || (versionValue = this.tombstones.get(uid)) == null || !this.canRemoveTombstone(maxTimestampToPrune, maxSeqNoToPrune, versionValue)) continue;
                this.removeTombstoneUnderLock(uid);
            }
            finally {
                if (lock == null) continue;
                lock.close();
            }
        }
    }

    synchronized void clear() {
        this.maps = new Maps();
        this.tombstones.clear();
    }

    public long ramBytesUsed() {
        return this.maps.ramBytesUsed() + this.ramBytesUsedForTombstones.get() + this.ramBytesUsedForArchive();
    }

    long ramBytesUsedForRefresh() {
        return this.maps.ramBytesUsed() + this.archive.getRamBytesUsed();
    }

    long reclaimableRefreshRamBytes() {
        return this.archive == LiveVersionMapArchive.NOOP_ARCHIVE ? this.maps.current.ramBytesUsed.get() : this.maps.ramBytesUsed() + this.archive.getReclaimableRamBytes();
    }

    long ramBytesUsedForArchive() {
        return this.archive.getRamBytesUsed();
    }

    long getRefreshingBytes() {
        return this.archive == LiveVersionMapArchive.NOOP_ARCHIVE ? this.maps.old.ramBytesUsed.get() : this.archive.getRefreshingRamBytes();
    }

    Map<BytesRef, VersionValue> getAllCurrent() {
        return this.maps.current.map;
    }

    Map<BytesRef, DeleteVersionValue> getAllTombstones() {
        return this.tombstones;
    }

    Releasable acquireLock(BytesRef uid) {
        return this.keyedLock.acquire(uid);
    }

    boolean assertKeyedLockHeldByCurrentThread(BytesRef uid) {
        assert (this.keyedLock.isHeldByCurrentThread(uid)) : "Thread [" + Thread.currentThread().getName() + "], uid [" + uid.utf8ToString() + "]";
        return true;
    }

    LiveVersionMapArchive getArchive() {
        return this.archive;
    }

    static {
        ConcurrentMap<Integer, Integer> map = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
        map.put(0, 0);
        long chmEntryShallowSize = RamUsageEstimator.shallowSizeOf(map.entrySet().iterator().next());
        BASE_BYTES_PER_CHM_ENTRY = chmEntryShallowSize + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
    }

    private static final class Maps {
        final VersionLookup current;
        final VersionLookup old;
        boolean needsSafeAccess;
        final boolean previousMapsNeededSafeAccess;

        Maps(VersionLookup current, VersionLookup old, boolean previousMapsNeededSafeAccess) {
            this.current = current;
            this.old = old;
            this.previousMapsNeededSafeAccess = previousMapsNeededSafeAccess;
        }

        Maps() {
            this(new VersionLookup(ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency()), VersionLookup.EMPTY, false);
        }

        boolean isSafeAccessMode() {
            return this.needsSafeAccess || this.previousMapsNeededSafeAccess;
        }

        boolean shouldInheritSafeAccess() {
            boolean mapHasNotSeenAnyOperations = this.current.isEmpty() && !this.current.isUnsafe();
            return this.needsSafeAccess || mapHasNotSeenAnyOperations && this.previousMapsNeededSafeAccess;
        }

        Maps buildTransitionMap() {
            return new Maps(new VersionLookup(ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency(this.current.size())), this.current, this.shouldInheritSafeAccess());
        }

        Maps invalidateOldMapForAssert() {
            return new Maps(this.current, VersionLookup.EMPTY, this.previousMapsNeededSafeAccess);
        }

        Maps invalidateOldMap(LiveVersionMapArchive archive) {
            archive.afterRefresh(this.old);
            return new Maps(this.current, VersionLookup.EMPTY, this.previousMapsNeededSafeAccess);
        }

        void put(BytesRef uid, VersionValue version) {
            this.current.put(uid, version);
        }

        void remove(BytesRef uid, DeleteVersionValue deleted) {
            this.current.remove(uid);
            this.current.updateMinDeletedTimestamp(deleted);
            if (this.old != VersionLookup.EMPTY) {
                this.old.remove(uid);
            }
        }

        long getMinDeleteTimestamp() {
            return Math.min(this.current.minDeleteTimestamp.get(), this.old.minDeleteTimestamp.get());
        }

        long ramBytesUsed() {
            return this.current.ramBytesUsed.get() + this.old.ramBytesUsed.get();
        }
    }

    public static final class VersionLookup {
        final AtomicLong ramBytesUsed = new AtomicLong();
        private static final VersionLookup EMPTY = new VersionLookup(Collections.emptyMap());
        private final Map<BytesRef, VersionValue> map;
        private boolean unsafe;
        private final AtomicLong minDeleteTimestamp = new AtomicLong(Long.MAX_VALUE);

        public void merge(VersionLookup versionLookup) {
            long existingEntriesSize = 0L;
            for (Map.Entry<BytesRef, VersionValue> entry : versionLookup.map.entrySet()) {
                VersionValue existingValue = this.map.get(entry.getKey());
                existingEntriesSize += existingValue == null ? 0L : VersionLookup.mapEntryBytesUsed(entry.getKey(), existingValue);
            }
            this.map.putAll(versionLookup.map);
            this.adjustRamUsage(versionLookup.ramBytesUsed() - existingEntriesSize);
            this.minDeleteTimestamp.accumulateAndGet(versionLookup.minDeleteTimestamp(), Math::min);
        }

        VersionLookup(Map<BytesRef, VersionValue> map) {
            this.map = map;
        }

        public VersionValue get(BytesRef key) {
            return this.map.get(key);
        }

        VersionValue put(BytesRef key, VersionValue value) {
            long ramAccounting = VersionLookup.mapEntryBytesUsed(key, value);
            VersionValue previousValue = this.map.put(key, value);
            this.adjustRamUsage(ramAccounting += previousValue == null ? 0L : -VersionLookup.mapEntryBytesUsed(key, previousValue));
            return previousValue;
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        int size() {
            return this.map.size();
        }

        public boolean isUnsafe() {
            return this.unsafe;
        }

        void markAsUnsafe() {
            this.unsafe = true;
        }

        VersionValue remove(BytesRef uid) {
            VersionValue previousValue = this.map.remove(uid);
            if (previousValue != null) {
                this.adjustRamUsage(-VersionLookup.mapEntryBytesUsed(uid, previousValue));
            }
            return previousValue;
        }

        public void updateMinDeletedTimestamp(DeleteVersionValue delete) {
            this.minDeleteTimestamp.accumulateAndGet(delete.time, Math::min);
        }

        public long minDeleteTimestamp() {
            return this.minDeleteTimestamp.get();
        }

        void adjustRamUsage(long value) {
            if (value != 0L) {
                long v = this.ramBytesUsed.addAndGet(value);
                assert (v >= 0L) : "bytes=" + v;
            }
        }

        public long ramBytesUsed() {
            return this.ramBytesUsed.get();
        }

        public static long mapEntryBytesUsed(BytesRef key, VersionValue value) {
            return BASE_BYTES_PER_BYTESREF + (long)key.bytes.length + (BASE_BYTES_PER_CHM_ENTRY + value.ramBytesUsed());
        }

        Map<BytesRef, VersionValue> getMap() {
            return this.map;
        }
    }
}

