/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface HttpBody
extends Releasable {
    public static Full fromBytesReference(BytesReference bytesRef) {
        return new ByteRefHttpBody(ReleasableBytesReference.wrap(bytesRef));
    }

    public static Full empty() {
        return new ByteRefHttpBody(ReleasableBytesReference.empty());
    }

    default public boolean isFull() {
        return this instanceof Full;
    }

    default public boolean isStream() {
        return this instanceof Stream;
    }

    default public Full asFull() {
        if (!1.$assertionsDisabled && !(this instanceof Full)) {
            throw new AssertionError();
        }
        return (Full)this;
    }

    default public Stream asStream() {
        if (!1.$assertionsDisabled && !(this instanceof Stream)) {
            throw new AssertionError();
        }
        return (Stream)this;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public record ByteRefHttpBody(ReleasableBytesReference bytes) implements Full
    {
    }

    public static interface Full
    extends HttpBody {
        public ReleasableBytesReference bytes();

        default public void close() {
        }
    }

    public static interface Stream
    extends HttpBody {
        @Nullable
        public ChunkHandler handler();

        public void addTracingHandler(ChunkHandler var1);

        public void setHandler(ChunkHandler var1);

        public void next();
    }

    @FunctionalInterface
    public static interface ChunkHandler
    extends Releasable {
        public void onNext(ReleasableBytesReference var1, boolean var2);

        default public void close() {
        }
    }
}

