/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node.tracker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.health.node.RepositoriesHealthInfo;
import org.elasticsearch.health.node.UpdateHealthInfoCacheAction;
import org.elasticsearch.health.node.tracker.HealthTracker;
import org.elasticsearch.repositories.InvalidRepository;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.UnknownTypeRepository;

public class RepositoriesHealthTracker
extends HealthTracker<RepositoriesHealthInfo> {
    private final RepositoriesService repositoriesService;

    public RepositoriesHealthTracker(RepositoriesService repositoriesService) {
        this.repositoriesService = repositoriesService;
    }

    @Override
    protected RepositoriesHealthInfo determineCurrentHealth() {
        Map<String, Repository> repositories = this.repositoriesService.getRepositories();
        if (repositories.isEmpty()) {
            return new RepositoriesHealthInfo(List.of(), List.of());
        }
        ArrayList<String> unknown = new ArrayList<String>();
        ArrayList<String> invalid = new ArrayList<String>();
        repositories.values().forEach(repository -> {
            if (repository instanceof UnknownTypeRepository) {
                unknown.add(repository.getMetadata().name());
            } else if (repository instanceof InvalidRepository) {
                invalid.add(repository.getMetadata().name());
            }
        });
        return new RepositoriesHealthInfo(unknown, invalid);
    }

    @Override
    protected void addToRequestBuilder(UpdateHealthInfoCacheAction.Request.Builder builder, RepositoriesHealthInfo healthInfo) {
        builder.repositoriesHealthInfo(healthInfo);
    }
}

