/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public abstract class ObjectArrayPriorityQueue<T>
implements Iterable<T>,
Releasable {
    private long size = 0L;
    private final long maxSize;
    final ObjectArray<T> heap;

    public ObjectArrayPriorityQueue(long maxSize, BigArrays bigArrays) {
        long heapSize;
        if (0L == maxSize) {
            heapSize = 2L;
        } else {
            if (maxSize < 0L || maxSize >= Long.MAX_VALUE) {
                throw new IllegalArgumentException("maxSize must be >= 0 and < 9223372036854775807; got: " + maxSize);
            }
            heapSize = maxSize + 1L;
        }
        this.heap = bigArrays.newObjectArray(heapSize);
        this.maxSize = maxSize;
    }

    protected abstract boolean lessThan(T var1, T var2);

    public final T add(T element) {
        long index = this.size + 1L;
        this.heap.set(index, element);
        this.size = index;
        this.upHeap(index);
        return this.heap.get(1L);
    }

    public void addAll(Collection<T> elements) {
        if (this.size + (long)elements.size() > this.maxSize) {
            throw new ArrayIndexOutOfBoundsException("Cannot add " + elements.size() + " elements to a queue with remaining capacity: " + (this.maxSize - this.size));
        }
        Iterator<T> iterator = elements.iterator();
        while (iterator.hasNext()) {
            this.heap.set(this.size + 1L, iterator.next());
            ++this.size;
        }
        for (long i = this.size >>> 1; i >= 1L; --i) {
            this.downHeap(i);
        }
    }

    public T insertWithOverflow(T element) {
        if (this.size < this.maxSize) {
            this.add(element);
            return null;
        }
        if (this.size > 0L && this.lessThan(this.heap.get(1L), element)) {
            T ret = this.heap.get(1L);
            this.heap.set(1L, element);
            this.updateTop();
            return ret;
        }
        return element;
    }

    public final T top() {
        return this.heap.get(1L);
    }

    public final T pop() {
        if (this.size > 0L) {
            T result = this.heap.get(1L);
            this.heap.set(1L, this.heap.get(this.size));
            this.heap.set(this.size, null);
            --this.size;
            this.downHeap(1L);
            return result;
        }
        return null;
    }

    public final T updateTop() {
        this.downHeap(1L);
        return this.heap.get(1L);
    }

    public final T updateTop(T newTop) {
        this.heap.set(1L, newTop);
        return this.updateTop();
    }

    public final long size() {
        return this.size;
    }

    public final void clear() {
        int i = 0;
        while ((long)i <= this.size) {
            this.heap.set(i, null);
            ++i;
        }
        this.size = 0L;
    }

    public final boolean remove(T element) {
        int i = 1;
        while ((long)i <= this.size) {
            if (this.heap.get(i) == element) {
                this.heap.set(i, this.heap.get(this.size));
                this.heap.set(this.size, null);
                --this.size;
                if ((long)i <= this.size && !this.upHeap(i)) {
                    this.downHeap(i);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean upHeap(long origPos) {
        long i = origPos;
        T node = this.heap.get(i);
        for (long j = i >>> 1; j > 0L && this.lessThan(node, this.heap.get(j)); j >>>= 1) {
            this.heap.set(i, this.heap.get(j));
            i = j;
        }
        this.heap.set(i, node);
        return i != origPos;
    }

    private void downHeap(long i) {
        T node = this.heap.get(i);
        long j = i << 1;
        long k = j + 1L;
        if (k <= this.size && this.lessThan(this.heap.get(k), this.heap.get(j))) {
            j = k;
        }
        while (j <= this.size && this.lessThan(this.heap.get(j), node)) {
            this.heap.set(i, this.heap.get(j));
            i = j;
            k = (j = i << 1) + 1L;
            if (k > this.size || !this.lessThan(this.heap.get(k), this.heap.get(j))) continue;
            j = k;
        }
        this.heap.set(i, node);
    }

    @Override
    public final Iterator<T> iterator() {
        return new Iterator<T>(){
            long i = 1L;

            @Override
            public boolean hasNext() {
                return this.i <= ObjectArrayPriorityQueue.this.size;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ObjectArrayPriorityQueue.this.heap.get(this.i++);
            }
        };
    }

    public final void close() {
        Releasables.close(this.heap);
        this.doClose();
    }

    protected void doClose() {
    }
}

